/******************************************************************
**  RCSID: $Id: plotter.h,v 1.15 2000/03/06 22:57:37 bjarthur Exp $
** Program: xdphys
**  Module: plotter.h
**  Author: cmalek
** Descrip: defines for plotter switch statements (for the pm_*.c)
**          files.
**
**     This file contains defines for all the different types of
**  plots that xdphys/calib/xdview can make.
**
**
** Revision History (most recent last)
**
*******************************************************************/

#ifndef _PLOTTER_H_
#define _PLOTTER_H_

#define PM_DEFAULT						-2
#define PM_NONE							-1
#define PM_CURVE						0
#define PM_RASTER						2
#define PM_RASTER_RAW					3
#define PM_PSTH							4
#define PM_ISIH							5
#define PM_MEANPHASE					6
#define PM_VS							7
#define PM_RAYLEIGH						8
#define PM_PERHIST						9
#define PM_PERHIST_LEFT      			11
#define PM_PERHIST_RIGHT     			13
#define PM_MAG							15
#define PM_PHASE						16
#define PM_DIFFERENCE_MAG				17
#define PM_DIFFERENCE_PHASE				18
#define PM_DISTORTION					19
#define PM_LEAK_MAG						20
#define PM_LEAK_PHASE					21
#define PM_LEAK_DISTORTION				22
#define PM_ROVER_ITD 					23
#define PM_ROVER_IID					24
#define PM_ROVER_SURFACE				25

#define PM_NVIEWS						26
#define PM_WAVES 27
#define PM_WAVES_OVR 28
#define PM_SPIKES 29
#define PM_SPIKES_OVR 30

extern char *pm_names[];

#define pm_type_error(type, view) fprintf(stderr, "The %s plotter cannot display views of type %s!\n", type, pm_names[view]) 

#define adjust_index(lr,ud) { \
			if((lr)>=nviews) (lr)=0; \
			if((lr)<0) (lr)=nviews-1; \
			if((ud)>=nsubviews[lr]) (ud)=0; \
			if((ud)<0) (ud)=nsubviews[lr]-1; }

typedef enum { SideLeft, SideRight, SideBoth } SideType;
typedef enum { OrderRaw , OrderPres } OrderType;
typedef enum { Separate, Difference } ChannelOpType;
typedef enum { LogNone, LogXAxis, LogYAxis, LogBoth } LogType;

typedef enum { DispWindow, DispPs, DispXFig, DispText, DispParms,
      PeakStats, IsihStats, SimilarityStats, CombineData, NSpikes,
      /*LinearityStats,*/ ProbDistribution, Ana, DispRasters, SigmoidStats
      } ActionType;

typedef struct plot_type {
	int				leak;
	SideType		side;
	OrderType		order;
	ChannelOpType	channel_op;
	int				plot_type;
} XDviewPlotType;

typedef struct xdview_args {
	int				*plot_type;
	int				nplottypes;

	int 			baw;
	int 			no_grid;
	int 			legend;
	int				log_x;	
	int				log_y;	
	int				no_errs;	
	int				normalize;
	int				show_raw_points;
	int				no_text_header;

	ActionType		action;
	char 			*other_parms;   /* hack */
	char			*out_file; 		/* hack */
} XDviewArgs;

extern int abi_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int bam_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int bc_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int beats_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int bf_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int bw_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int cal_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int cf_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int fiid_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int fr_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int iid_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int int_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int itd_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int mono_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int nop_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int rover_do_plot(FDO *, FILEDATA *, int, int, FILE *);
extern int txt_do_plot(FDO *, FILEDATA *, int, int, FILE *);

#endif /* _PLOTTER_H_ */
