/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: parms.c,v 2.59 2001/04/12 04:33:27 cmalek Exp $
** Program: dowl
**  Module: parms.c
**  Author: mazer
**  Decrip: standard menu for data analysis parameters
**
** Revision History (most recent last)
**
** Thu Oct  1 19:08:07 1992 mazer
**  made into a real object file instead of a header file
**
** Mon Nov 16 10:33:10 1992 mazer
**    modified to rely on standalone xanalysis program for user i/o
**  this is just a lookup module now.. Now there's a stand alone
**  program "xanalysis" which any application can fork off using
**  the "runAnalysis()" function in analysis.c -- Only one copy
**  at a time, please -- locks ARE checked.
**    Applications requesting analysis parameters should do so
**  using the "lookupAnalysis...()" functions defined in analysis.c/h.
**  these will automatically reload the analysis parameters from
**  disk when they get tweaked by this module (provided you save!!)
**
** Thu Feb  4 12:06:05 1993 mazer
**  changed varsnew() to build a SMALL hash table and added a
**  cleanup function to help track memory leaks..
**
** Sun Feb  5 19:11:41 1995 mazer
**  added stuff for allow_no_analysis_file() to avoid circular
**  looping in xanalysis application
**
** -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
** copied from xanalysis.c.
** 
** Mon Nov 16 10:26:58 1992 mazer
**  stand alone analysis parameters worksheet
**  derived from xdowl.c and analysis.c
**
** Mon Nov 16 16:37:56 1992 mazer
**  automatically undates the worksheet when things are changed.
**   - if you "Enter" a new value, update to disk occurs
**   - if you "Leave" the application window, and the database
**     is dirty, then and update to disk occurs.
**
** Fri Jun 11 01:12:20 1993 mazer
**  now uses svar_post_changed_hook -- so, anytime something gets
**  changed, the disk cache gets refreshed..
**
** Thu Feb  3 14:22:24 1994 mazer
**  added timeouts to watch the analysis file, in case something
**  gets changed underneath me..
**
** Thu Feb  5 19:20:00 1995 mazer
**  added allow_no_analysis_file() call do avoid a "race"
**  conditions
** -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
** 97.5 bjarthur
**  decided to undo the standalone style of xanalysis and just
**		make it a button in xdview.  the fields in the worksheet are
**		saved in config.xdphys as a consequence when an FDO window
**		is created after appRun() in xdphys.  this is redundant as
**		they are also saved in config.parms, but it shouldn't be a
**		problem.
**  changed name to parms.c
**	use_delay now means to use the Delay portion of each Epoch to
**		compute spontaneous rate, but DON'T subtract it from each
**		driven range (as before).
**	made dur-relative apply to [begin,end]-spont as well.
**
** 97.7 bjarthur
**  changed ws.c so that redundant saving of fields was eliminated.
**    this was necessary because duplicate copies were getting out
**    of sync.
**
** 98.02 bjarthur
**  added parms.area flag for findPeak.  now can compute either
**  the left and right width points, or the left and right areas
**
** 98.09 bjarthur
**  added parms.isih_percent
**
*******************************************************************/

#include "xdphyslib.h"

#define AFILE "~/.xdphysrc/config.parms"

Field ws_parms[] = {
	{ WS_VSEP, "General" },
	{ "parms.dur_relative",	"%b", 1, "1" },
	{ "parms.begin_data (ms)", "%f", 8, "10.0" },
	{ "parms.end_data (ms)", "%f",	8, "10.0" },
	{ "parms.begin_spont (ms)","%f", 8, "0.0" },
	{ "parms.end_spont (ms)", "%f",	8, "0.0" },
	{ "parms.use_delay", "%b", 1, "1" },
	{ WS_VSEP, "Histograms" },
	{ "parms.psth_use_start_end", "%b", 1, "0" },
	{ "parms.psth_start (ms)", "%f", 6, "0.0" },
	{ "parms.psth_end (ms)", "%f", 6, "400.0" },
	{ "parms.psth_bin (ms)", "%f", 6, "2.0" },
	{ "parms.psth_triangle", "%b", 1, "0" },
	{ "parms.isih_bin (ms)", "%f", 6, "0.25" },
	{ "parms.isih_max (ms)", "%f",	6, "20" },
	{ "parms.isih_percent (ms)", "%f",	4, "1.0" },
/*
	{ "parms.perhist_depint (all,#)", "%s", 6, "all" },
  { "parms.ach_bin (ms)", "%f", 6, "1.0" },
  { WS_VSEP, "Spike Densities" },
  { "parms.sdens_sigma", "%f", 6, "3.0" },
  { "parms.sdens_iters", "%d", 2, "10" },
*/
	{ WS_VSEP, "Main Lobe Wdth Cal" },
	{ "parms.ceil", "%d", 1, "2" },
	{ "parms.floor", "%d", 1, "3" },
	{ "parms.width_percent","%d", 3, "50" },
	{ "parms.area","%b", 1, "0" },
	{ WS_VSEP, "Rover Module" },
	{ "parms.rov_high", "%d",	3, "50" },
	{ "parms.rov_low",	"%d",	3, "25" },
	{ WS_VSEP, "Spike Mask (ttl=-1,out=-2,mu=-3)" },
	{ "parms.spikemask (code,#)","%d", 2, "-1" },
	{ WS_VSEP, "Analog Files" },
	{ "parms.ana_threshold (xRMS)","%d", 2, "3" },
	{ "parms.ana_pre (ms)","%f", 3, "1" },
	{ "parms.ana_post (ms)","%f", 3, "2" },
	{ NULL },
};

typedef struct {
	Widget        psh;
	int           state;
} Slot;

static void loadParms(int);
static void saveParms(void);
static void popup_parms(Slot*);
static void popdown_parms(Slot*);
static void ParmsCloseCB(Widget, XtPointer, XtPointer);
static void ParmsSaveCB(Widget, XtPointer, XtPointer);
static void ParmsReloadCB(Widget, XtPointer, XtPointer);
static void ParmsHelpCB(Widget, XtPointer, XtPointer);
static void ParmsCB(Widget, XtPointer, XtPointer);

extern int debugflag;
static FieldList parms_ftab[MAXFIELDS];
static SVAR_TABLE *parms_svar_table;
static Slot G_slot={NULL,0};

static void loadParms(int reload)
{
	if(reload || (parms_svar_table==NULL)) {
		if (parms_svar_table == NULL)
			parms_svar_table = varsnew(0, 31);
		if (!loadvars(AFILE, parms_svar_table)) {
			fprintf(stderr, "WARNING: can't understand/parse %s\n", AFILE);
			exit(1); } }
	ws_tows(parms_ftab,parms_svar_table);
}

char *lookupParms(char *p)
{
  loadParms(0);
	return(getvar(p, parms_svar_table));
}

int lookupParms_int(char *p)
{
  loadParms(0);
	return(getvar_int(p, parms_svar_table));
}

float lookupParms_float(char *p)
{
  loadParms(0);
	return(getvar_float(p, parms_svar_table));
}

void cleanupParms(void)
{
	if (parms_svar_table) {
		varsdelete(parms_svar_table);
		parms_svar_table = NULL;
	}
}

static void saveParms(void)
{
	ws_tosvars(parms_ftab,parms_svar_table);
	ws_writeconfig(AFILE, ws_parms, sizeof(ws_parms) / sizeof(Field),
		parms_svar_table);
	/*loadParms(1);*/
}

static void popup_parms(Slot *slot)
{
	slot->state = 1;
	popup(slot->psh);
}

static void popdown_parms(Slot *slot)
{
	slot->state = 0;
	popdown(slot->psh);
}

void parms_close_hook()
{
  if(G_slot.state)
	  popdown_parms(&G_slot);
}

static void ParmsCloseCB(Widget w, XtPointer slot_blah, XtPointer call_data)
{
  Slot *slot = (Slot*)slot_blah;

	popdown_parms(slot);
}

static void ParmsSaveCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	saveParms();
}

static void ParmsReloadCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	loadParms(1);
}

static void ParmsHelpCB(Widget w, XtPointer name_blah, XtPointer call_data)
{
	char tmp[100],*file;
  char *name = (char*)name_blah;

	sprintf(tmp,"$(XDPHYSDIR)/doc/xdview.%s.doc",name);
	file = envexpand(tmp);
	if (!probefile(file)) {
		alert("Can't find help file.");
		return; }
	help(file,name);
}

static void ParmsCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	if(!G_slot.state) {
	  popup_parms(&G_slot); }
	else
		popdown_parms(&G_slot);
}

Widget make_parms(Widget parent, String name, String label,
	Widget horiz, Widget vert)
{
	Widget h;
	Widget w1, w2, w3, w4;

  initsvars();

  if(!probefile(AFILE))
    saveParms();
  loadParms(1);

  if(G_slot.psh==NULL) {
		G_slot.psh = pop_ws_new(TopLevel, ws_parms, "Parms", &h,
			parms_ftab, parms_svar_table),

    w1 = button_new(XtParent(h),"Close", "Close",
			(XtCallbackProc) ParmsCloseCB, (XtPointer) &G_slot, h, NULL);
		accel_from(XtParent(h), w1);

  	w2 = button_new(XtParent(h),"Save", "Save",
			(XtCallbackProc) ParmsSaveCB, NULL, w1, NULL);
		accel_from(XtParent(h), w2);

  	w3 = button_new(XtParent(h),"Reload", "Reload",
			(XtCallbackProc) ParmsReloadCB, NULL, w2, NULL);
		accel_from(XtParent(h), w3);

		w4 = button_new(XtParent(h),"Help", "Help",
			(XtCallbackProc) ParmsHelpCB, (XtPointer) "parms", w3, NULL);
		accel_from(XtParent(h), w4); }

  return(button_new(parent, name, label, ParmsCB, NULL, horiz, vert));
}
