#include "xdphyslib.h"

/* (C) Copr. 1986-92 Numerical Recipes Software #.3. */
/* (C) Copr. 1986-92 Numerical Recipes Software #.3. */

/* same as NRs gaussj() but modified to fail gracefully */
#define NR_SWAP(a,b) {temp=(a);(a)=(b);(b)=temp;}
int my_gaussj(double **a, int n, double **b, int m)
{
	int *indxc,*indxr,*ipiv;
	int i,icol,irow,j,k,l,ll;
	double big,dum,pivinv,temp;

	indxc=ivector(1,n);
	indxr=ivector(1,n);
	ipiv=ivector(1,n);
	for (j=1;j<=n;j++) ipiv[j]=0;
	for (i=1;i<=n;i++) {
		big=0.0;
		for (j=1;j<=n;j++)
			if (ipiv[j] != 1)
				for (k=1;k<=n;k++) {
					if (ipiv[k] == 0) {
						if (fabs(a[j][k]) >= big) {
							big=fabs(a[j][k]);
							irow=j;
							icol=k;
						}
					} else if (ipiv[k] > 1)
            return(0);
				}
		++(ipiv[icol]);
		if (irow != icol) {
			for (l=1;l<=n;l++) NR_SWAP(a[irow][l],a[icol][l])
			for (l=1;l<=m;l++) NR_SWAP(b[irow][l],b[icol][l])
		}
		indxr[i]=irow;
		indxc[i]=icol;
		if (a[icol][icol] == 0.0)
      return(0);
		pivinv=1.0/a[icol][icol];
		a[icol][icol]=1.0;
		for (l=1;l<=n;l++) a[icol][l] *= pivinv;
		for (l=1;l<=m;l++) b[icol][l] *= pivinv;
		for (ll=1;ll<=n;ll++)
			if (ll != icol) {
				dum=a[ll][icol];
				a[ll][icol]=0.0;
				for (l=1;l<=n;l++) a[ll][l] -= a[icol][l]*dum;
				for (l=1;l<=m;l++) b[ll][l] -= b[icol][l]*dum;
			}
	}
	for (l=n;l>=1;l--) {
		if (indxr[l] != indxc[l])
			for (k=1;k<=n;k++)
				NR_SWAP(a[k][indxr[l]],a[k][indxc[l]]);
	}
	free_ivector(ipiv,1,n);
	free_ivector(indxr,1,n);
	free_ivector(indxc,1,n);

  return(1);
}
#undef NR_SWAP


#define NR_SWAP(a,b) {swap=(a);(a)=(b);(b)=swap;}

void my_covsrt(double **covar, int ma, int ia[], int mfit)
{
	int i,j,k;
	double swap;

	for (i=mfit+1;i<=ma;i++)
		for (j=1;j<=i;j++) covar[i][j]=covar[j][i]=0.0;
	k=mfit;
	for (j=ma;j>=1;j--) {
		if (ia[j]) {
			for (i=1;i<=ma;i++) NR_SWAP(covar[i][k],covar[i][j])
			for (i=1;i<=ma;i++) NR_SWAP(covar[k][i],covar[j][i])
			k--;
		}
	}
}
#undef NR_SWAP


void my_mrqcof(double x[], double y[], double sig[], int ndata, double a[],
  int ia[], int ma, double **alpha, double beta[], double *chisq,
	void (*funcs)(double, double [], double *, double [], int))
{
	int i,j,k,l,m,mfit=0;
	double ymod,wt,sig2i,dy,*dyda;

	dyda=dvector(1,ma);
	for (j=1;j<=ma;j++)
		if (ia[j]) mfit++;
	for (j=1;j<=mfit;j++) {
		for (k=1;k<=j;k++) alpha[j][k]=0.0;
		beta[j]=0.0;
	}
	*chisq=0.0;
	for (i=1;i<=ndata;i++) {
		(*funcs)(x[i],a,&ymod,dyda,ma);
		sig2i=1.0/(sig[i]*sig[i]);
		dy=y[i]-ymod;
		for (j=0,l=1;l<=ma;l++) {
			if (ia[l]) {
				wt=dyda[l]*sig2i;
				for (j++,k=0,m=1;m<=l;m++)
					if (ia[m]) alpha[j][++k] += wt*dyda[m];
				beta[j] += dy*wt;
			}
		}
		*chisq += dy*dy*sig2i;
	}
	for (j=2;j<=mfit;j++)
		for (k=1;k<j;k++) alpha[k][j]=alpha[j][k];
	free_dvector(dyda,1,ma);
}


/* same as NRs mrqmin(), but modified to handle singular matrices better.
specifically, it returns -1 if all okay, 0 if bad and don't know why, and
positive integer if matrix is singular because given parameter number. */
int my_mrqmin(double x[],double y[], double sig[], int ndata, double a[],
  int ia[], int ma, double **covar, double **alpha, double *chisq,
	void (*funcs)(double, double [], double *, double [], int), double *alamda)
{
	int j,k,l,m;
	static int mfit;
	static double ochisq,*atry,*beta,*da,**oneda;

  /*****************/
  double **tmp,*w,**v,min,max;
  int i,ii;

  tmp = dmatrix(1,ma,1,ma);
  w = dvector(1,ma);
  v = dmatrix(1,ma,1,ma);
  /*****************/

	if (*alamda < 0.0) {
		atry=dvector(1,ma);
		beta=dvector(1,ma);
		da=dvector(1,ma);
		for (mfit=0,j=1;j<=ma;j++)
			if (ia[j]) mfit++;
		oneda=dmatrix(1,mfit,1,1);
		*alamda=0.001;
		my_mrqcof(x,y,sig,ndata,a,ia,ma,alpha,beta,chisq,funcs);
		ochisq=(*chisq);
		for (j=1;j<=ma;j++) atry[j]=a[j];
	}
	for (j=0,l=1;l<=ma;l++) {
		if (ia[l]) {
			for (j++,k=0,m=1;m<=ma;m++) {
				if (ia[m]) {
					k++;
					covar[j][k]=alpha[j][k];
				}
			}
			covar[j][j]=alpha[j][j]*(1.0+(*alamda));
			oneda[j][1]=beta[j];
		}
	}

  /*****************/
  for(i=1; i<=mfit; i++)
    for(ii=1; ii<=mfit; ii++)
      tmp[i][ii] = covar[i][ii];

  dsvdcmp(tmp,mfit,mfit,w,v);

  for(min=max=w[1], i=2; i<=mfit; i++) {
    if(w[i]<min) min=w[i];
    if(w[i]>max) max=w[i]; }
  if((min/max)<1.0e-5) {
    for(i=1; i<=mfit; i++) {
      w[i]=covar[i][ii];
      for(ii=2; ii<=mfit; ii++)
        w[i]+=covar[i][ii]; }
    for(min=w[1],ii=1, i=2; i<=mfit; i++) {
      if(w[i]<min) {
        min=w[i];
        ii=i; } }
    free_dmatrix(tmp,1,ma,1,ma);
    free_dvector(w,1,ma);
    free_dmatrix(v,1,ma,1,ma);
    return(ii); }

	if(!my_gaussj(covar,mfit,oneda,1)) {
    for(i=1; i<=mfit; i++) {
      for(ii=1; ii<=mfit; ii++)
        fprintf(stdout,"%g ",tmp[i][ii]);
      fprintf(stdout,"\n"); }
    fprintf(stdout,"\n");
    free_dmatrix(tmp,1,ma,1,ma);
    free_dvector(w,1,ma);
    free_dmatrix(v,1,ma,1,ma);
    return(0); }
  /*****************/

	for (j=1;j<=mfit;j++) da[j]=oneda[j][1];
	if (*alamda == 0.0) {
		my_covsrt(covar,ma,ia,mfit);
		free_dmatrix(oneda,1,mfit,1,1);
		free_dvector(da,1,ma);
		free_dvector(beta,1,ma);
		free_dvector(atry,1,ma);
    /*****************/
    free_dmatrix(tmp,1,ma,1,ma);
    free_dvector(w,1,ma);
    free_dmatrix(v,1,ma,1,ma);
    /*****************/
		return(-1);
	}
	for (j=0,l=1;l<=ma;l++)
		if (ia[l]) atry[l]=a[l]+da[++j];
	my_mrqcof(x,y,sig,ndata,atry,ia,ma,covar,da,chisq,funcs);
	if (*chisq < ochisq) {
		*alamda *= 0.1;
		ochisq=(*chisq);
		for (j=0,l=1;l<=ma;l++) {
			if (ia[l]) {
				for (j++,k=0,m=1;m<=ma;m++) {
					if (ia[m]) {
						k++;
						alpha[j][k]=covar[j][k];
					}
				}
				beta[j]=da[j];
				a[l]=atry[l];
			}
		}
	} else {
		*alamda *= 10.0;
		*chisq=ochisq;
	}

  /*****************/
  free_dmatrix(tmp,1,ma,1,ma);
  free_dvector(w,1,ma);
  free_dmatrix(v,1,ma,1,ma);
  /*****************/

  return(-1);
}


#define TOL 1.0e-5

void my_svdfit(double x[], double y[], double sig[], int ndata, double a[],
  int ma, double **u, double **v, double w[], double *chisq,
	void (*funcs)(double, double[], int))
{
	int j,i;
	double wmax,tmp,thresh,sum,*b,*afunc;

	b=dvector(1,ndata);
	afunc=dvector(1,ma);
	for (i=1;i<=ndata;i++) {
		(*funcs)(x[i],afunc,ma);
		tmp=1.0/sig[i];
		for (j=1;j<=ma;j++) u[i][j]=afunc[j]*tmp;
		b[i]=y[i]*tmp;
	}
	dsvdcmp(u,ndata,ma,w,v);
	wmax=0.0;
	for (j=1;j<=ma;j++)
		if (w[j] > wmax) wmax=w[j];
	thresh=TOL*wmax;
	for (j=1;j<=ma;j++)
		if (w[j] < thresh) w[j]=0.0;
	dsvbksb(u,w,v,ndata,ma,b,a);
	*chisq=0.0;
	for (i=1;i<=ndata;i++) {
		(*funcs)(x[i],afunc,ma);
		for (sum=0.0,j=1;j<=ma;j++) sum += a[j]*afunc[j];
		*chisq += (tmp=(y[i]-sum)/sig[i],tmp*tmp);
	}
	free_dvector(afunc,1,ma);
	free_dvector(b,1,ndata);
}
#undef TOL
