/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: notepad.c,v 2.45 1998/07/22 18:15:59 bjarthur Exp $
** Program: dowl
**  Module: notepad
**  Author: mazer
** Descrip: notpad "widget"
**
** Revision History (most recent last)
**
** Wed Feb  8 00:22:07 1995 mazer
**  creation date
**
*******************************************************************/

#include "xdphyslib.h"

static void CyclePrevCB(Widget, XtPointer, XtPointer);
static void CycleNextCB(Widget, XtPointer, XtPointer);

static void CyclePrevCB(Widget w, XtPointer n_blah, XtPointer call_data)
{
  NOTEPAD *n = (NOTEPAD*)n_blah;

  if (n->cpage > 0) {
    n->cpage -= 1;
    XRaiseWindow(XtDisplay(n->pages[n->cpage]), XtWindow(n->pages[n->cpage]));
    label_set(n->label, n->titles[n->cpage]);
  }
}

static void CycleNextCB(Widget w, XtPointer n_blah, XtPointer call_data)
{
  NOTEPAD *n = (NOTEPAD*)n_blah;

  if (n->cpage < (n->npages - 1)) {
    n->cpage += 1;
    XRaiseWindow(XtDisplay(n->pages[n->cpage]), XtWindow(n->pages[n->cpage]));
    label_set(n->label, n->titles[n->cpage]);
  }
}

NOTEPAD *notepad_new(Widget parent)
{
  NOTEPAD *n = (NOTEPAD *) calloc(1, sizeof(NOTEPAD));

  n->frame = form_new(parent, "frame", 0);
  n->holder = form_new(n->frame, "holder", 0);
  n->prev = button_new(n->frame, "<<", "<<", CyclePrevCB, n, NULL, NULL);
  n->next = button_new(n->frame, ">>", ">>", CycleNextCB, n, n->prev, NULL);
  n->label = label_new(n->frame, "Notepad", n->next, NULL, 1);
  XtVaSetValues(n->holder, XtNfromHoriz, NULL, XtNfromVert, n->prev, NULL);

  n->cpage = -1;
  n->npages = 0;
  n->pages = NULL;
  n->titles = NULL;
  return(n);
}

Widget notepad_add(NOTEPAD *n, char *title)
{
  if (n->pages == NULL) {
    n->npages = 1;
    n->pages = (Widget *) calloc(n->npages, sizeof(Widget));
    n->titles = (char **) calloc(n->npages, sizeof(char *));
  } else {
    n->npages += 1;
    n->pages = (Widget *) realloc(n->pages, n->npages * sizeof(Widget));
    n->titles = (char **) realloc(n->titles, n->npages * sizeof(char *));
  }
  n->cpage = n->npages - 1;
  n->titles[n->cpage] = strsave(title);
  n->pages[n->cpage] = form_new(n->holder, "page", 0);
  label_set(n->label, n->titles[n->cpage]);

  return(n->pages[n->cpage]);
}

void notepad_destroy(NOTEPAD *n)
{
  int i;

  for (i = 0; i < n->npages; i++) {
    free(n->titles[i]);
  }
  if (n->titles)
    free(n->titles);
  if (n->pages)
    free(n->pages);
  XtDestroyWidget(n->frame);
  free(n);
}
