#include "xdphyslib.h"
#include "xdphys.h"
#include "mod_gen_util.h"

static void alt_alert(char*,...);

static void alt_alert(char *foo,...)
{
}

syn_spec *gen_SSArray_Gen(int *nstims, int rand, char *range_stim,
      int reps, int nodups, int spont)
{
  int *stimarray,i,j,count;
  syn_spec *ssarray;
  char *p,cop[256];
  void (*foo)(char*,...);
  int nstims2;

  assert(spont==0);
  assert(rand==0);
  assert(nodups==0);
  assert(reps==1);

  i=0;
  count=10;
  assert((ssarray=(syn_spec*)malloc(count*sizeof(syn_spec)))!=NULL);
  p = strntok(range_stim,";",0);
  while(p) {
    strcpy(cop,p);

    foo = syn_alert;
    syn_alert = alt_alert;
    stimarray = StimArray_Gen(&nstims2,0,cop,1,1,0);
    syn_alert = foo;

    if(stimarray!=NULL) {
      for(j=0; j<nstims2; j++) {
        fd_syn_spec_parse(NULL,stimarray[j],ssarray+i);
        if((++i)==count) {
          count += 10;
          assert((ssarray=(syn_spec*)realloc(ssarray,
                count*sizeof(syn_spec)))!=NULL); } }
      free(stimarray); }
    else {
      fd_syn_spec_parse(cop,0,ssarray+i);
      if(ssarray[i].class == SC_INVALID) {
        alert("Stim: \"%s\" illegal syn_class\n%s", p, synthesize_help());
        return(NULL); }
      if((++i)==count) {
        count += 10;
        assert((ssarray=(syn_spec*)realloc(ssarray,
              count*sizeof(syn_spec)))!=NULL); } }
    p = strntok(NULL,";",0); }

  (*nstims) = i;
  return(ssarray);
}


int *gen_mono_StimArray_Gen(int *nstims, int rand,
      char *range_mono, int reps, int nodups, int spont)
{
	char *p;
	char *q = NULL;
	int *ret_val, tmp, flag;

	assert(spont == 0);
	assert(rand == 0);
	assert(nodups == 0);
	assert(reps == 1);
	assert(range_mono != NULL);

	assert((q = (char *) calloc(strlen(range_mono) + 1, sizeof(char)))
	       != NULL);
	strcpy(q, range_mono);

	(*nstims) = 0;

	for (p = strtok(q, ","); p != NULL; p = strtok(NULL, ",")) {
		if (strncasecmp(p, "l", 1) == 0) {
			flag = 1;
			tmp = LMONO;
		} else if (strncasecmp(p, "r", 1) == 0) {
			flag = 1;
			tmp = RMONO;
		} else if (strncasecmp(p, "b", 1) == 0) {
			flag = 1;
			tmp = BIN;
		} else {
			flag = 0;
			alert("\"mono\" must be LEFT, RIGHT or BIN");
		}
		if (flag) {
			(*nstims)++;
			if ((*nstims) == 1)
				assert((ret_val=(int *)malloc((*nstims)*sizeof(int))) != NULL);
			else
				assert((ret_val=(int *)realloc(ret_val,(*nstims)*sizeof(int))) 
					!= NULL);
			ret_val[(*nstims) - 1] = tmp;
		}
	}

	free(q);

	return (ret_val);
}


int *gen_itd_StimArray_Gen(int *nstims, int rand,
      char *range_itd, int reps, int nodups, int spont, syn_spec *ssarray,
      int nssarray)
{
  char depstr[256];
  int *stimarray;
  int start, stop, step;
  int ncycles, nsteps, i;

  if (sscanf(range_itd, "%d/%d", &ncycles, &nsteps) == 2) {
    if ((nssarray==1) && (ssarray[0].class == SC_TONE)) {
      stop = RND2INT(((float)ncycles/2.0) * (1.0e6/ssarray[0].parms.tone.freq));
      start = -stop;
      step = RND2INT((float)(stop-start)/(float)(nsteps*ncycles));
      sprintf(depstr,"%d:%d:%d",start,stop,step);
      if((stimarray = StimArray_Gen(nstims, rand, depstr,
            reps, nodups, spont))==NULL)
        return(NULL); }
    else {
      alert("cycle ranges for single pure tones only");
      return(NULL); } }
  else if (sscanf(range_itd, "period/%d", &i) == 1) {
    if ((nssarray==1) && (ssarray[0].class == SC_TONE)) {
      start = 0;
      stop = RND2INT(1.0e6 / ssarray[0].parms.tone.freq);
      step = i;
      sprintf(depstr,"%d:%d:%d",start,stop,step);
      if((stimarray = StimArray_Gen(nstims, rand, depstr,
            reps, nodups, spont))==NULL)
        return(NULL); }
    else {
      alert("period range for single pure tones only");
      return(NULL); } }
  else {
    if((stimarray = StimArray_Gen(nstims, rand, range_itd,
          reps, nodups, spont))==NULL)
      return(NULL); }

  return(stimarray);
}

int only_this_stim(syn_spec *ssarray, int nstims, syn_class foo)
{
  int i,ret_val=1;

  for(i=0; i<nstims; i++) {
    if((ssarray[i].class != foo) && (ssarray[i].class != SC_INVALID)) {
      ret_val=0;
      break; } }

  return(ret_val);
}
