/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

#define SWAP(a,b,type) { type tmp; tmp=a; a=b; b=tmp; }
#define COPY_ARRAY(from,to,n,type) { \
	assert(((to)=(type*)malloc((n)*sizeof(type)))!=NULL); \
	memcpy((to),(from),(n)*sizeof(type)); }

extern int	debugflag;
extern char	*progname;
extern int	single_step_mode;
extern int	cur_ntrials;
extern int	cur_trialnum;
extern int	cur_nreps;
extern int	cur_repnum;
extern int	cur_depvar;

extern char *shortname(char*);

extern int floatcompare(const void*, const void*);
extern int intcompare(const void*, const void*);

#define SPONT (-6666)

#ifndef AUTOLOG
# define AUTOLOG "AutoLogFile"
#endif

#ifndef DRUGLOG
# define DRUGLOG "DrugsLog"
#endif

#ifndef PASSLOG
# define PASSLOG "PassLog"
#endif

extern char *next_alphanum_counter(char*, int);

extern void help(char*, char*);

extern char *strsave(char*);

extern void xd_setFc(int, int, int);
extern int single_step(int);
extern int set_trial_vars(int, int, int, int);
double getRad(void);
double getRadWithArgs(double, double);


#ifdef mc700

/* these are part of libc on suns, but not mentioned in include/string.h */
extern int 	strcasecmp(char*, char*);/* this is part of libc on suns */
extern int 	strncasecmp(char*, char*, int);	/* this is part of libc on suns */

#endif
