/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: misc.c,v 2.55 1999/03/12 01:57:59 bjarthur Exp $
** Program: dowl
**  Module: misc.c
**  Author: jamie
** Descrip: misc funcions
**
** Revision History (most recent last)
**  
** Tue Aug  6 11:20:44 PDT 1996
**  spliced stimArray stuff out and put in StimArray.c
**
** Sat Feb 22 18:45:43 1992 mazer
**  changed genStimArray() to do randomize in sets.. thought it
**  already did, oops.
**  
** Thu Jun 25 01:53:56 1992 mazer
**  added do_mallocinfo()
**
** Mon Aug 10 17:02:40 PDT 1992 dhb
**  extended spikeMask() to allow naming of events using letters
**  (e.g. a - i and A - I are the same as 1 - 9). This allows up to
**  26 event types rather than the 9 allowed before.
**
** Fri Sep 18 14:04:17 1992 mazer
**  added mergeRasters() from dhb
**
** Tue Mar  2 22:48:09 1993 mazer
**  changed countRaster() to use the spikemask as follows:
**    before: matched spikes where (<mask> & <eventstamp>) != 0
**       now: matches spikes where <mask> == <eventstamp>
**
** Wed Mar  3 18:13:18 1993 mazer
**  deleted spikeMask() and spikeMaskstr() an replaced with
**  matchEvent()
**
** Sun Nov 14 19:08:17 1993 mazer
**  added checkRange() function
**
** Thu Nov 18 15:12:46 1993 mazer
**  cleaned up randomizeArray() function
**
** Tue Nov 30 19:06:23 1993 mazer
**  added depstr to writeRaster()
**
** Tue Nov 30 21:53:34 1993 mazer
**   moved all the xxxRaster() functions to rasternfs.c
**
** Wed Dec  1 14:51:15 1993 mazer
**  do_mallocinfo and OBSOLETE stuff reaped..
**
** Wed Jan 26 22:53:08 1994 mazer
**  added genDisjointStimArray()
**
** Tue Feb  8 17:22:44 1994 mazer
**  moved choose_atten() here since it was duplicated in
**  at least 3 modules (freq2, itd2 and rover)
**
** Fri Feb 25 22:48:15 1994 mazer
**  added spont argument to genDisjointStimArray()
**
** Wed May 11 13:24:22 1994 mazer
**  added next_alphanum_counter()
**
** Sep 96 bjarthur
**  moved stringlib.c in here
**  moved globals.c in here
**  moved generateDummySpikeTrain() to spiker.c
**
** 97.1 bjarthur
**   moved intcompare() and floatcompare() in here
**
** 97.4 bjarthur
**   added int_to_float_vec for FD_compare_intensities
**
** 98.11 bjarthur
**   deleted some unused stuff
**   moved all is_getRad stuff here
**
*******************************************************************/

#include "xdphyslib.h"

int	debugflag	= 0;
char	*progname	= NULL;
int single_step_mode = 0;
int cur_ntrials = 0;
int cur_trialnum = 0;
int cur_nreps = 0;
int cur_repnum = 0;
int cur_depvar = 0;


char *shortname(char *p)
{
  char *q;

  if ((q = rindex(p, '/')) != NULL)
    return(q + 1);
  else
    return(p);
}

int floatcompare(const void *v1, const void *v2)
{
  float *i = (float *) v1;
  float *j = (float *) v2;
  return((int)((*i) - (*j)));
}

int intcompare(const void *v1, const void *v2)
{
  int *i = (int *) v1;
  int *j = (int *) v2;
  return(*i - *j);
}


#include <ctype.h>
/* This thing's a kludge to get greater than 99 units in two digits!
**   the counting sequence is as follows:
**    01, 01, 02 ... 99, A0, A1, A2 ... Z9
**   this means that you should be able to have about 359 units per
**   animal before another kludge becomes necessary.. clever, eh?
** Note: only the 2 last digits are looked at, so Z9 should wrap
**   around into 00..
** Note: this should always be of strlen 2, so that it's not necessary
**   to use sprintf(...%02s...) to pad it..
*/
char *next_alphanum_counter(char *p, int incr)
{
  int u;
  char d1, d2;
  static char idbuf[3];

  if (strlen(p) > 2) {
    p = p + strlen(p) - 2;
  }
  if (sscanf(p, "%c%c", &d1, &d2) == 1) {
    if (d1 >= '0' && d1 <= '9')
      u = (d1 - '0');
    else
      return("??");
  } else {
#ifndef __linux__
    extern char toupper();
#endif __linux__
    if (d1 >= 'a' && d1 <= 'z')
      d1 = toupper(d1);
    
    if (d1 >= 'A' && d1 <= 'Z')
      u = 10 * ((d1 - 'A') + 10);
    else if (d1 >= '0' && d1 <= '9')
      u = 10 * ((d1 - '0'));
    else
      return("??");
    
    if (d2 >= '0' && d2 <= '9')
      u += (d2 - '0');
    else
      return("??");
  }
  u += incr;
  /* note: 360 = z0 + 1 */
  if (u >= 360)
    u = 0;
  else if (u < 0)
    u = 360 - u;

  if ((u / 10) > 9) {
    idbuf[0] = (u / 10) - 10 + 'A';
  } else {
    idbuf[0] = (u / 10) + '0';
  }
  idbuf[1] = (u % 10) + '0';
  idbuf[2] = 0;
  return(idbuf);
}

void help(char *file, char *title_word)
{
  FILE *fptr;
  char tmp[100], title[100], *docs;

  if((fptr=fopen(file,"r"))==NULL) {
    alert("Can't open help file.");
    return; }

  docs = NULL;
  while (fgets(tmp, sizeof(tmp), fptr) != NULL) {
    if (docs)  {
      docs = (char*)realloc(docs, strlen(docs)+strlen(tmp)+2);
      strcat(docs, tmp); }
    else {
      docs = (char*)malloc(strlen(tmp)+2);
      strcpy(docs, tmp); } }

  fclose(fptr);

  sprintf(title,"%s help file",title_word);
  pop_text(title,docs,60,0);
}

char *strsave(char *q)
{
  if (q)
    return(strcpy((char *)malloc(strlen(q) + 1), q));
  else
    return(q);
}

#ifdef mc700
/*
** home brew versions of strcasecmp because RTU 4.0 doesn't have them.
** as far as I can tell they work exactly as the system ones do on the
** DECstation under Ultrix 4.0 - even down to the exact values returned
** even though the man page specifies only the sign of the return values
*/

int strcasecmp(char *p, char *q)
{
  register char pp, qq;

  do {
    pp = *(p++);
    qq = *(q++);
    if (pp && isupper(pp)) pp = tolower(pp);
    if (qq && isupper(qq)) qq = tolower(qq);
    if (pp != qq) break;
  } while (pp & qq);
  return((int)(pp - qq));
}

int strncasecmp(char *p, char *q, int n)
{
  register char pp, qq;
  register int i;

  pp = qq = i = 0;
  do {
    if (++i > n) break;
    pp = *(p++);
    qq = *(q++);
    if (pp && isupper(pp)) pp = tolower(pp);
    if (qq && isupper(qq)) qq = tolower(qq);
    if (pp != qq) break;
  } while (pp & qq);
  return((int)(pp - qq));
}
#endif

void xd_setFc(int dafc, int adfc, int evtfc)
{
	SF("daFc",dafc);
	SF("adFc",adfc);
	SF("evtFc",evtfc);
}

int single_step(int ret)
{
	int what_to_do;
	int outsize, dachans;
	int insize, adchans;
	xword *outbuf, *inbuf;

	dachans=is_getDAnchans();
	adchans=is_getADnchans();

	outbuf=is_getDAbuffer(&outsize);
	inbuf=is_getADbuffer(&insize);

	while (single_step_mode) {
		what_to_do = npop_box("** Single Step Breakpoint **",
			"Next", "Halt run",
			"View Output (xo)", "View Input (xo)", NULL);
		switch (what_to_do) {
			case 1:
				return(ret);
			case 2:
				progRunning = 0;
				return(ret);
			case 3:
				if (outsize > 0) {
					char fn[100];
					sprintf(fn, "/tmp/ss%d.snd", getpid());
					unlink(fn);
					savewave(fn, outbuf, GI("daFc"), outsize, dachans,
						"SingleStepper Output Buffer", progname, 0.0, 0.0, NULL, 0);
					sprintf(fn, "xo -noio /tmp/ss%d.snd & ", getpid());
					system(fn);
				} else {
					alert("Nothing to scope!\n");
				}
				break;
			case 4:
				if (insize > 0) {
					char fn[100];
					sprintf(fn, "/tmp/ss%d.snd", getpid());
					unlink(fn);
					savewave(fn, inbuf, GI("adFc"), insize, adchans,
						"SingleStepper Input Buffer", progname, 0.0, 0.0, NULL, 0);
					sprintf(fn, "xo -noio /tmp/ss%d.snd & ", getpid());
					system(fn);
				} else {
					alert("Nothing to scope!\n");
				}
				break;
		}
	}
	return(IS_OK);
}


int set_trial_vars(int trialnum, int ntrials, int nreps, int depvar)
{
	if (nreps < 1) {
		fprintf(stderr, "is_trial: nreps < 1 .. fatal error\n");
		exit(1);
	}
	cur_ntrials = ntrials;
	cur_trialnum = trialnum;
	cur_nreps = nreps;
	cur_repnum = (int)(((float)trialnum) / (((float)ntrials) / (float)nreps));
	cur_depvar = depvar;
	DEBUG(stderr, "is_trial(%d, %d, %d) = %d\n", trialnum, ntrials, nreps, cur_repnum);
	return(cur_repnum);
}

double getRad(void)
{
  return(getRadWithArgs((double)cur_repnum,
			(double) ((cur_nreps != 0) ? cur_nreps : 1)));
}

double getRadWithArgs(double repnum, double nreps)
{
  return(2.0 * M_PI * (double)repnum / (double) nreps);
}
