/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: menu.c,v 2.46 1998/07/22 18:15:59 bjarthur Exp $
** Program: dowl
**  Module: menu.c
**  Author: mazer
** Descrip: R4/R5 drop down menu implementation
**
** Revision History (most recent last)
**
** Sat Feb 15 14:54:53 1992 mazer
**  major cleanup, as follows:
**        if CallbackFN   --> then selection calls the function
**   else if CallbackData --> toggle: take as pointer to an int/bool
**   else                 --> toggle: use svar from menutext
**
*******************************************************************/

#include "xdphyslib.h"

#include "check.bm"
#include "nocheck.bm"
#include "menu.bm"

static char *menutext_to_svar(char*);
static void CheckCallback(Widget, XtPointer, XtPointer);

static char *menutext_to_svar(char *l)
{
  char *p, *q;

  p = strsave(l);
  if ((q = index(p, ' ')) != NULL)
    *q = 0;
  return(p);
}

static void CheckCallback(Widget entry, XtPointer item_blah,
      XtPointer call_data)
{
  MENU_ENTRY *item = (MENU_ENTRY*)item_blah;
  int i;

  if (item->callback_data != NULL) {
    i = (*(int *)item->callback_data = !(*(int *)item->callback_data));
  } else {
    i = (SI(item->svar_name, !(GI(item->svar_name))));
  }
  menu_check(entry, i);
}

void menu_check(Widget entry, int i)
{
  static Pixmap check_mark;
  static Pixmap nocheck_mark;
  static int check_mark_init = 0;

  if (check_mark_init == 0) {
    check_mark_init = 1;
    check_mark = makePixmap(check_bits, check_width, check_height);
    nocheck_mark = makePixmap(nocheck_bits, nocheck_width, nocheck_height);
  }
  
  if (i)
    XtVaSetValues(entry, XtNleftBitmap, check_mark, NULL);
  else
    XtVaSetValues(entry, XtNleftBitmap, nocheck_mark, NULL);
}

Widget menu_new(Widget parent, String label, MENU_ENTRY list[], Widget horiz,
      Widget vert)
{
  Widget button;
  static Pixmap menupix;
  static int menupix_init = 0;

  if (menupix_init == 0)
    menupix_init = 1;
    menupix = makePixmap(menu_bits, menu_width, menu_height);

  button = XtVaCreateManagedWidget(label, menuButtonWidgetClass, parent,
		   XtNlabel, label, XtNleftBitmap, menupix,
		   XtNcursorName, "sb_left_arrow", XtNfromHoriz, horiz,
		   XtNfromVert,	vert, NULL);
  menu_new_subrt(button, list);
  return(button);
}

Widget menu_new_subrt(Widget button, MENU_ENTRY list[])
{
  int i;
  char *p;
  Widget menu, entry;

  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, button, NULL);

  for (i = 1; list[i].label_str != NULL; i++) {
    if (strcmp(list[i].label_str, MENU_SEP) == 0 || !(*list[i].label_str)) {
      entry = XtVaCreateManagedWidget("menusep", smeLineObjectClass, menu,
				      XtNsensitive, False,
				      XtNvertSpace, 40,
				      NULL);
      
    } else {
      if ((p = rindex(list[i].label_str, '.')) != NULL)
        p++;
      else
        p = list[i].label_str;
        entry = XtVaCreateManagedWidget(list[i].label_str,
		          smeBSBObjectClass, menu,
				      XtNlabel, p,
				      XtNleftMargin, check_width + 6,
				      XtNvertSpace, 40, NULL);
      if (list[i].callback_fn != NULL) {
        list[i].svar_name = NULL;
        XtAddCallback(entry, XtNcallback, 
		      list[i].callback_fn, list[i].callback_data);
      } else if (list[i].callback_data != NULL) {
        list[i].svar_name = NULL;
        menu_check(entry, *(int *)list[i].callback_data);
        XtAddCallback(entry, XtNcallback, CheckCallback, (void *) &list[i]);
      } else {
        list[i].svar_name = menutext_to_svar(list[i].label_str);
        menu_check(entry, GI(list[i].svar_name));
        XtAddCallback(entry, XtNcallback, CheckCallback, (void *) &list[i]);
      }
    }
  }
  return(menu);
}
