/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: keeper.c,v 2.45 1999/01/27 00:10:54 bjarthur Exp $
** Program: dowl
**  Module: keeper.c
**  Author: mazer
** Descrip: geometry keeper
**
** Revision History (most recent last)
**
** Sat Feb 13 11:34:45 1993 mazer
**  geometry keeper modules
**
** 97.12 bjarthur
**  fixed bug in the popuping up of dock slots such that they now popup
**  in the position they were last.  required a change from top_new() to
**  pop_new() in pop_ws_new(), and a call to popdown() and dloop_sync()
**  _twice_ in saveGeometry().
**
*******************************************************************/

#include "xdphyslib.h"

void saveGeometry(void)
{
  int i;
  Position x, y;
  char *p, *n;

  assert(global_svar_table != NULL);

	for (i=0; i<TopLevel->core.num_popups; i++) {
		popdown(TopLevel->core.popup_list[i]); /* this is to avoid window creep */
		mssleep(250);    /* due to the stinkin' window manager */
		dloop_sync();
		XtVaGetValues(TopLevel->core.popup_list[i],
					XtNx, &x, XtNy, &y, NULL);
		if ((x!=0) || (y!=0)) {
		  n = XtName(TopLevel->core.popup_list[i]);
		  p = (char *)malloc(strlen(n) + 30);
		  sprintf(p, "geometry.x.%s", n);
		  SI(p, x);
		  sprintf(p, "geometry.y.%s", n);
		  SI(p, y);
		  free(p); } }
}

void getGeometry(Widget w, Position *xp, Position *yp)
{
  char *n, *p;
 
  if (global_svar_table == NULL) {
    (*xp) = (*yp) = 0; }
	else {
    n = XtName(w);
    p = (char *)malloc(strlen(n) + 30);
    if (xp) {
      sprintf(p, "geometry.x.%s", n);
      (*xp) = GI(p); }
    if (yp) {
      sprintf(p, "geometry.y.%s", n);
      (*yp) = GI(p); }
    free(p);

    if (((*xp) < 0) || ((*xp) > WidthOfScreen(XtScreen(w))))
      (*xp) = 0;
    if (((*yp) < 0) || ((*yp) > HeightOfScreen(XtScreen(w))))
      (*yp) = 0; }
}
