/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: fopen2.c,v 2.48 1999/01/26 21:04:04 bjarthur Exp $
** Program: xdphys
**  Module: fopen2.c
**  Author: mazer
** Descrip: wrapper for fopen to add some frills..
**
** Revision History (most recent last)
**
** Mon Dec 26 11:26:43 1994 mazer
**  date of creation :: from old fopener.c
**
*******************************************************************/

#include "xdphyslib.h"

typedef enum {
  NOCOMPRESS, COMPRESS, GZIP
} CompMode;

static int readable(char*);

static int readable(char *filename)
{
  if (access(filename, R_OK) >= 0) {
    return(1);
  } else {
    return(0);
  }
}

FILE *fopen2(char *filename, char *mode)
{
  FILE *fp;
  CompMode comp;
  char *pipeline, *ext;

  if ((ext = extension(filename)) == NULL) {
    comp = NOCOMPRESS;
  } else if (strcmp(ext, ".Z") == 0) {
    comp = COMPRESS;
  } else if (strcmp(ext, ".gz") == 0) {
    comp = GZIP;
  } else {
    comp = NOCOMPRESS;
  }

  if (strncmp(mode, "r", 1) == 0) {
    switch (comp)
      {
      case NOCOMPRESS:
	return(fopen(filename, mode));
	break;
      case COMPRESS:
	if (!readable(filename)) {
	  return(NULL);
	} else {
	  pipeline = (char *)malloc(strlen(filename) + 100);
	  sprintf(pipeline, "uncompress <%s 2>/dev/null", filename);
	  if ((fp = popen(pipeline, mode)) == NULL) {
	    perror(pipeline);
	  }
	  free(pipeline);
	  if (debugflag && fp)
	    {fprintf(stderr, "opened %s for \"%s\"\n", filename, mode);}
	  return(fp);
	}
	break;
      case GZIP:
	if (!readable(filename)) {
	  return(NULL);
	} else {
	  pipeline = (char *)malloc(strlen(filename) + 100);
	  sprintf(pipeline,
		  "gzip --stdout --decompress <%s 2>/dev/null", filename);
	  if ((fp = popen(pipeline, mode)) == NULL) {
	    perror(pipeline);
	  }
	  free(pipeline);
	  if (debugflag && fp)
	    {fprintf(stderr, "opened %s for \"%s\"\n", filename, mode);}
	  return(fp);
	}
	break;
      }
  } else if (strncmp(mode, "w", 1) == 0) {
    switch (comp)
      {
      case NOCOMPRESS:
	return(fopen(filename, mode));
	break;
      case COMPRESS:
	pipeline = (char *)malloc(strlen(filename) + 100);
	sprintf(pipeline, "compress >%s 2>/dev/null", filename);
	if ((fp = popen(pipeline, mode)) == NULL) {
	  perror(pipeline);
	}
	free(pipeline);
	if (debugflag && fp)
	  {fprintf(stderr, "opened %s for \"%s\"\n", filename, mode);}
	return(fp);
	break;
      case GZIP:
	pipeline = (char *)malloc(strlen(filename) + 100);
	sprintf(pipeline, "gzip --stdout >%s 2>/dev/null", filename);
	if ((fp = popen(pipeline, mode)) == NULL) {
	  perror(pipeline);
	}
	free(pipeline);
	if (debugflag && fp)
	  {fprintf(stderr, "opened %s for \"%s\"\n", filename, mode);}
	return(fp);
	break;
      }
  } else if (strncmp(mode, "a", 1) == 0) {
    switch (comp)
      {
      case NOCOMPRESS:
	return(fopen(filename, mode));
	break;
      case COMPRESS:
	fprintf(stderr, "Can't auto-append to compressed file \"%s\".\n",
		filename);
	return(NULL);
	break;
      case GZIP:
	fprintf(stderr, "Can't auto-append to gzip'd file \"%s\".\n",
		filename);
	return(NULL);
	break;
      }
  } else {
    fprintf(stderr, "fopen2(\"%s\",\"%s\") unknown mode\n", filename, mode);
    return(NULL);
  }
  return(NULL);
}
