/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: fdobj.h,v 2.63 2000/03/06 22:57:36 bjarthur Exp $
** Program: dowl
**  Module: fdobj.h
**  Author: mazer
** Descrip: interface for filedata object (fdobj.c)
**
** Revision History (most recent last)
**
** Wed Jun  9 19:44:58 1993 mazer
**  created
**
** Fri Oct  8 18:01:15 1993 mazer
**  changed order of FDO_mode enum values to make rasters come
**  up before secondary stuff..
**
*******************************************************************/

#ifndef _FDOBJ_H_
#define _FDOBJ_H_

extern char *FDObj_Colors[];
extern int FDObj_numColors;
extern AtPlotMark FDObj_Mark[];
extern int FDObj_numMark;
extern AtPlotLine FDObj_Line[];
extern int FDObj_numLine;

typedef struct {
	int lr;  /* left,right */
	int ud;  /* up,down */
} FDObj_ViewType;


typedef struct {
	/* sort of public data */
	FILEDATA **fds;
	int nfds;
	Widget form, filenom;
	Widget close, between;
	Widget graph, xaxis, yaxis;
	Widget over, keep, dup, up, down;
	Widget flags, dump, dumppsh, fit, fitpsh, vsm, vsmpsh;
	FDObj_ViewType view;
	float epoch, delay, dur;
	char *pattern;

	/* ABSOLUTELY private data */
	int no_X;
	int *sum_code;
	int meta_num_all;	/* this is the number of *ndata_all's */
	int *ndata_all;
	float **xdata_all;
	float **ydata_all;
	Widget **atlines;
	int *num_atlines;
	int destroy_old;
	Widget selected;
	Widget point_tag;
	Widget clickinfo;
	int just_zoomed;
	int to_tty;
	int baw, no_grid, legend;
	int log_x, log_y;
	int no_errs, normalize, show_raw_points;
	int no_text_header;
	int vsm_data;
	Widget loc_display;
	int loc_state;
	MENU_ENTRY *flag_menu;
} FDO;

extern void  FDObj_Close(FDO *);
extern FDO  *FDObj_New(FILEDATA*, Widget, FDObj_ViewType*,int);
extern void  FDObj_Add(FDO*, FILEDATA*);
extern FDO  *FDObj_File_New(char*, Widget, FDObj_ViewType*);
extern FDO  *FDObj_FileBrowser_New(char*, Widget, FDObj_ViewType*);
extern void  FDObj_Update(FDO *, FILE *);
extern void  FDObj_Update_ForceView(FDO*, FILE*, int);
extern char *FDObj_Title(FDO*, char*, int);
extern XtArgVal FDObj_Legend(FDO*, int);
extern void  FDObj_Add_Data_All(FDO*, float*, float*, int);
extern void  FDObj_AddLine(FDO*, int, float*, float*, float*, int, AtDataType,
      WidgetClass, XtArgVal, XtArgVal, XtArgVal, XtArgVal);
extern void FDObj_CommentsCB(Widget, XtPointer, XtPointer);
extern void FDObj_PrintRasters(Widget, XtPointer, XtPointer);

extern void CombineDataFN(Widget, XtPointer, XtPointer);
/*extern void LinearityStatsFN(Widget, XtPointer, XtPointer);*/

#endif _FDOBJ_H_
