/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: fd1.h,v 1.16 2001/03/27 06:59:24 cmalek Exp $
** Program: dowl
**  Module: plotfile.h
**  Author: mazer
** Descrip: plotfile.c interface file
**
** Revision History (most recent last)
**  
** Thu Nov 12 12:40:06 1992 mazer
**  added filedata_read() etc
**
*******************************************************************/

#ifndef _FD1_H_
#define _FD1_H_

typedef struct {
  int           nrasters;       /* number of rasters in this object */
  int          *pres_order;     /* presentation order of rasters */
  spike_t      **rastlist;      /* really int *rastlist[nrasters] */
  char        **deplines;       /* full string value of depvar=<> */
  int          *depints;        /* integer (atoi) value of depvar=<> */
  float       **avepmk;         /* actually avepmk[nrasters][gsr_nmodels] */
  int       ana_nchans;
  int       **chan_ids;       
  xword       ***ana;
} FD1_RawData;

#define FD1_RAWDATA(data) ((FD1_RawData*)(data->rawdata))

extern void FD1_curveFN(FDO*,FILEDATA*,int,FILE*);
extern void FD1_rasterFN(FDO*,FILEDATA*,int,int,FILE*);
extern void FD1_psthFN(FDO*,FILEDATA*,int,FILE*);
extern void FD1_isihFN(FDO*,FILEDATA*,int,FILE*);
extern void FD1_autocorrFN(FDO*,FILEDATA*,int,FILE*);
extern void FD1_densityFN(FDO*,FILEDATA*,int,FILE*);
extern void FD1_perhist1FN(FDO*, FILEDATA*, int, FILE*, float, int, int);
extern void FD1_perhist2FN(FDO*, FILEDATA*, int, FILE*, float, int);
extern void FD1_similarity_stats(Widget, XtPointer, XtPointer); 
/*
extern void FD1_linearity_stats(FDO*, char*, FILE*);
*/
extern void FD1_prob_distribution(Widget, XtPointer, XtPointer); 
extern void FD1_isih_stats_menu(FDO*);
extern void FD1_isih_stats(Widget, XtPointer, XtPointer); 
extern void FD1_perhist_stats_menu(FDO*);
extern void FD1_perhist_stats(Widget, XtPointer, XtPointer); 

extern void FD1_contra_ipsi(FILEDATA*);
extern int  FD1_reader(FILE*, FILEDATA*, int);
extern void FD1_freeRawData(FILEDATA*);
extern int  FD1_free(FILEDATA*);

extern float *FD1_get_means(FILEDATA*);
extern float *FD1_get_depvals(FILEDATA*);
extern float *FD1_get_stderrs(FILEDATA*);
extern int    FD1_get_ndata(FILEDATA*);
extern int   *FD1_get_n(FILEDATA*);
extern int  **FD1_get_nspikes(FILEDATA*);
extern char **FD1_get_depstrs(FILEDATA*);
extern int   *FD1_get_depints(FILEDATA*);
extern float *FD1_get_rawcounts(FILEDATA*);
extern int    FD1_get_nrasters(FILEDATA*);
extern int   *FD1_get_pres_order(FILEDATA*);
extern spike_t  **FD1_get_rastlist(FILEDATA*);
extern xword    ***FD1_get_ana(FILEDATA*);
extern int    **FD1_get_chan_ids(FILEDATA*);
extern int    FD1_get_ana_nchans(FILEDATA*);
extern void   FD1_peak_stats(Widget, XtPointer, XtPointer);
extern void FD1_combine_data(FDO*, char*, FILE*);

#endif _FD1_H_
