/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: dsp.h,v 2.46 2001/07/09 04:44:41 cmalek Exp $
** Program: dowl
**  Module: dsp
**  Author: mazer
** Descrip: interface for simple dsp routines
**
** Revision History (most recent last)
**
*******************************************************************/

/* apply window for ffts? */
#define DSP_WINDOW		1
#define DSP_NOWINDOW	0

#define next2(n, n2) for ((n2) = 1; (n2) < (n); (n2) <<= 1) ;

extern double dsp_calcrms(xword*, int, int, int);
extern float dsp_fitsin(xword*, int, int, int, float, float*, float*);
extern void dsp_stripDC(xword*, int, int);
extern float *dsp_highpass(float**, int, int, float);
extern void	dsp_highpass_xword(xword*, int, int, int, float);
extern void	norm_ifft(float*, int, int);

/* =========================== */
/* Following stuff is disabled */
/* =========================== */
#if(0)
/* next largest power of two */

/* rescale to peak amp? */
#define DSP_RESCALE		1
#define DSP_NORESCALE	0

extern void	ap2ri(float, float, float*, float*);
extern void	ri2ap(float, float, float*, float*);

extern void	*dsp_spectrumPlot(xword*, int, int, int, char*);
extern void	*dsp_phasePlot(xword*, int, int, int, char*, int, int);
extern void	*dsp_psdPlot(xword*, int, int, int, char*);
extern int	dsp_correl(xword*, int, int, xword*, int, int, float, int,
                      int, float**, float**);
extern void	*dsp_correlPlot(xword*, int, int, xword*, int, int, float, int,
                      char*, int);

extern void	dsp_bandpass(float**, int, float, float, int, int, int);
extern void	dsp_bandpass_xword(xword*, int, float, float, int, int,int,int);
extern void	dsp_gaussianfilter(xword*, int, int, float, float, int, int,
                      int);



extern int	dsp_compute_sonogram(short*, int, int, float***, int*, int*,
                      int, float, int);
extern int	dsp_pgm_sonogram(float**, int, int, int, float, float, int,
                      float, float, char*);

/* kernel generator functions -- for use with dsp_convolve(): */
extern float   *dsp_lpkernel(int, float, int);
extern float   *dsp_bpkernel(int, float, float, int);
extern float   *dsp_softbpkernel(int, float, float, float, int);
extern float   *dsp_gausskernel(int, float, float, int);
extern float   *dsp_blackmankernel(int);

/* time-domain convolution: returns net gain in peak-to-peak amplitude */
extern float	dsp_convolve(xword*, int, int, float*, int);

#endif
