/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: dloop.c,v 2.45 1998/07/22 18:15:59 bjarthur Exp $
** Program: dowl
**  Module: dloop.c
**  Author: mazer
** Descrip: x-startup and event-loop support
**
** Revision History (most recent last)
**
** Thu Nov  3 12:36:25 1994 mazer
**  split out from xloop.c the dloop_XXX() functions
**  this is to allow redefinition for tk apps..
**
*****************************************************************/

#include "xdphyslib.h"

void dloop(void)
{
  XEvent event;
  static int first_time = 0;

  if (TopLevel == NULL) {
    fprintf(stderr, "dloop called before startx()\n");
    exit(1);
  }

  if (first_time != 0) {
    fprintf(stderr, "dloop: event loop entered twice!\n");
    exit(1);
  } else {
    first_time = 1;
  }
    
  for (;;) {
    XtAppNextEvent(TopLevelContext, &event);
    XtDispatchEvent(&event);
  }
}

int dloop_empty(void)
{
  register int n;

  if (TopLevel == NULL)
    return(0);

  for (n = 0; XtAppPending(TopLevelContext); n++) {
    XtAppProcessEvent(TopLevelContext, XtIMAll);
  }
  return(n);
}

int dloop_once(void)
{
  if (TopLevel == NULL)
    return(0);

  if (XtAppPending(TopLevelContext)) {
    XtAppProcessEvent(TopLevelContext, XtIMAll);
    return(1);
  }
  return(0);
}

int dloop_sync(void)
{
  if (TopLevel == NULL)
    return(0);

  XFlush(XtDisplay(TopLevel));
  XSync(XtDisplay(TopLevel), False); 
  return(dloop_empty());
}
