/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: copyright.c,v 2.46 1998/07/22 18:15:59 bjarthur Exp $
** Program: dowl
**  Module: copyright.c
**  Author: mazer
** Descrip: copyright banner thingy
**
** Revision History (most recent last)
**
** Wed Sep 29 00:29:16 1993 mazer
**  creation date
**
*******************************************************************/

#include "xdphyslib.h"

#include "owl.bm"

static Widget psh = NULL;

static void KillNoticeCB(Widget, XtPointer, XtPointer);
static void KillNoticeTimerCB(XtPointer, XtIntervalId *);

static void KillNoticeCB(
	Widget w,
	XtPointer client_data,
	XtPointer call_data)
{
  if (psh != NULL) {
    XtDestroyWidget(psh);
    psh = NULL;
  }
}

static void KillNoticeTimerCB(
	XtPointer client_data,
	XtIntervalId *id)
{
  if (psh != NULL) {
    XtDestroyWidget(psh);
    psh = NULL;
  }
}

void DisplayNotice(char *args)
{
  char buf[1000];
  Widget form, label, icon, ok;
  static Pixmap bitmap;
  static int bitmap_init = 0;

  if (probefile("~/.xdphysrc/.nocopyright"))
    return;

  if (args) {
    sprintf(buf, "%s", args);
  } else {
    sprintf(buf, "\n\n%s\n\nCopyright (c) 1993 James Mazer\n\n", progname);
  }

  if (bitmap_init == 0) {
    bitmap_init = 1;
    bitmap = makePixmap(owl_bits, owl_width, owl_height); }

  psh = pop_new(TopLevel, "Copyright");
  form = XtVaCreateManagedWidget("popbox", formWidgetClass, psh, NULL);
  icon = XtVaCreateManagedWidget("icon", labelWidgetClass, form,
				 XtNbitmap, bitmap,
				 XtNborderWidth, 1, 
				 NULL);
  label = label_new(form, "label", icon, icon, 0);
  XtVaSetValues(label, XtNlabel, buf, NULL);
  ok = button_new(form, "b1", "b1", KillNoticeCB, NULL, icon, label);
  XtVaSetValues(ok, XtNlabel, "Ok", NULL);
  ReverseColors(ok);
  accel_from(form, ok);
  popup_at(psh, 0, 0);

  XtAppAddTimeOut(XtWidgetToApplicationContext(psh),
		  3000, KillNoticeTimerCB, NULL);
}
  
