/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: comments.c,v 2.48 1999/01/26 21:04:04 bjarthur Exp $
** Program: xdphys
**  Module: comments
**  Author: jamie
**  Decrip: get user-comments with defaulting
**
** Revision History (most recent last)
** Mon Jul 13 23:26:00 1992 mazer
**  creation date
**
** Sun Jul 19 12:41:15 1992 mazer
**  changed to use multiline svars
**
*******************************************************************/

#include "xdphyslib.h"

char *getComments(char *fname)
{
  static char buf[1000];
  char *p, *msg;

  if ((p = GS("lastcomment")) != NULL)
    strncpy(buf, p, sizeof(buf));
  else
    strcpy(buf, "");

  if (*buf == 0)
    strcpy(buf, "So kill me!");

  msg = (char *)malloc(strlen(p = basename(fname)) + 100);
  sprintf(msg, "Comments about %s:", p);
  p = pop_text(msg, buf, sizeof(buf) - 1, 1);
  free(msg);
  if (buf[strlen(buf) - 1] != '\n')
    strcat(buf, "\n");
  SS("lastcomment", buf);
  return(p);
}

void writeComments(char *comment, FILE *fp)
{
  char *p, *q;

  if (comment) {
    if (*comment) {
      for (q = p = comment; *p; p++) {
	if (*p == '\n') {
	  *p = 0;
	  fprintf(fp, ";com %s\n", q);
	  *p = '\n';
	  q = p + 1;
	}
      }
    } else {
      fputs(";com Not a temp file, no user comment!\n", fp);
    }
  } else {
    fputs(";com Temp File: No user comments [they would've been here!]\n", fp);
  }
}

char *readComments(FILE *fp, char *datafile)
{
  char *comments, cbuf[100], *p;

  comments = NULL;
  while (fgets(cbuf, sizeof(cbuf), fp) != NULL) {
    if (strncmp(cbuf, "END_COMMENTS", 12) == 0) {
      if (comments == NULL) {
        return(strsave(";; no comments\n"));
      } else {
        return(comments);
      }
    }
    p = (strncmp(cbuf, ";com ", 5) == 0) ? cbuf + 5 : cbuf;
    if (comments)  {
      comments = (char *)realloc(comments, strlen(comments) + strlen(p) + 2);
      strcat(comments, p);
    } else {
      comments = (char *)malloc(strlen(p) + 2);
      strcpy(comments, p);
    }
  }
  if (debugflag)
    fprintf(stderr, "FD_readComments: %s COMMENTS block short or lost\n",
            datafile);
  return(NULL);
}
