/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: clockbar.c,v 2.46 1998/07/22 18:15:59 bjarthur Exp $
** Program: dowl
**  Module: clockbar.c
**  Author: mazer
**  Decrip: embedded or standalone clockbar
**
** Revision History (most recent last)
**
** Sun Nov 22 13:12:03 1992 mazer
**  creation date :: derived from xdowl.c and xanalysis.c
**
** Wed Nov 25 23:03:36 1992 mazer
**  can now be compiled as is for a clockbar_build function
**  or with -DSTANDALONE to make a standalone tool
**
** Tue Mar  8 00:23:50 1994 mazer
**  just a library file now..
**
*******************************************************************/

#include "xdphyslib.h"

static char 	        *clockstatefile = "~/.xdphysrc/config.clock";
static SVAR_TABLE       *clock_svar_table = NULL;
static void 	        *sessClk = NULL;
static void 	        *drugClk = NULL;
static void 		*userClk = NULL;

static void delimitDrugEntry(FILE*);
static void NewDrugs(Widget, XtPointer, XtPointer);

static void delimitDrugEntry(FILE *fp)
{
  int d;

  for (d = 70; d >= 0; d--) {
    fputs(d ? "-" : "-\n", fp);
  }
}

static void NewDrugs(Widget w, XtPointer new_session_blah, XtPointer call_data)
{
  int new_session = (int)new_session_blah;
  char buf[1000];
  char *p;
  int hrs, mins, secs;
  FILE *logfp;

  if ((p = getvar("lastdrugs", clock_svar_table)) != NULL)
    strncpy(buf, p, sizeof(buf));
  else
    strcpy(buf, "");

  if (*buf == 0)
    beep(0);
  if ((p = pop_text("Drug Entry", buf, sizeof(buf) - 1, 1)) != NULL) {
    if (buf[strlen(buf) - 1] != '\n')
      strcat(buf, "\n");

    if ((logfp = fopen2(AUTOLOG, "a")) != NULL) {
      delimitDrugEntry(logfp);
      fprintf(logfp, "%s :: DRUGS\n", GS("time"));
      if (clock_read(drugClk, &hrs, &mins, &secs))
	fprintf(logfp, "%02d:%02d:%02d elapsed\n", hrs, mins, secs);
      fputs(p, logfp);
      fclose(logfp);
    } else {
      notify("Can't open logfile: %s, restarting clock anyway", AUTOLOG);
    }

    if ((logfp = fopen2(DRUGLOG, "a")) != NULL) {
      delimitDrugEntry(logfp);
      fprintf(logfp, ">>> %s\n", GS("time"));
      fputs(p, logfp);
      if (clock_read(drugClk, &hrs, &mins, &secs))
	fprintf(logfp, "ELAPSED: %02d:%02d:%02d\n", hrs, mins, secs);
      fclose(logfp);
    } else {
      notify("Can't open logfile: %s, restarting clock anyway", AUTOLOG);
    }

    clock_reset(drugClk, CLOCK_RESTART);
    if (new_session)
      clock_reset(sessClk, CLOCK_RESTART);
    setvar("lastdrugs", p, clock_svar_table);
  }
}


void clockbar_save(void)
{
  if (sessClk != NULL)
    savevars(clockstatefile, clock_svar_table);
}

Widget clockbar_build(Widget parent, int alarm_mins, int interval_secs,
      void (*quit_cb)())
/*
     int alarm_mins;		used only if > 0
     int interval_secs;		used only if > 0
*/
{
  Widget form, x, drugs, nsess, quit;
  Widget psh = NULL;

  if (clock_svar_table != NULL) {
    fprintf(stderr, "clockbar_build called second time.. you lose\n");
    exit(1);
  }
  clock_svar_table = varsnew(0, 31);

  setvar_int("drug-alarm", 60, clock_svar_table);
  setvar_int("update-interval", 1, clock_svar_table);

  if (!loadvars(clockstatefile, clock_svar_table))
    fprintf(stderr,
	    "warning: can't find config file \"%s\"\n", clockstatefile);

  if (alarm_mins > 0)
    setvar_int("drug-alarm", alarm_mins, clock_svar_table);
  if (interval_secs > 0)
    setvar_int("update-interval", interval_secs, clock_svar_table);

  if (parent == NULL) {
    psh = parent = top_new(TopLevel, "clockbar");
  }
  form = form_new(parent, "clockform", 0);
  if (quit_cb != NULL)
    quit = button_new(form, "Quit", "Quit", quit_cb, NULL, NULL, NULL);
  else
    quit = NULL;
  drugs = button_new(form, "drug", "drug", NewDrugs, NULL, quit, NULL);
  nsess = button_new(form, "sess", "sess", NewDrugs, (XtPointer)1, drugs, NULL);

  if (debugflag) {
    fprintf(stderr, "drug-alarm = %d min\n",
	   getvar_int("drug-alarm", clock_svar_table));
    fprintf(stderr, "update-interval = %d secs\n",
	   getvar_int("update-interval", clock_svar_table));
  }

  /*
   * make some clocks
   */

  x = clock_new(form, "drugClk", nsess, NULL, clockstatefile,
		clock_svar_table, CLOCK_SYSTEM,
		&drugClk, "D:", /* user-settable alarm in s */
		getvar_int("drug-alarm",
			   clock_svar_table) * 60, /* update in ms */
		getvar_int("update-interval", clock_svar_table) * 1000);
  x = clock_new(form, "sessClk",
		x, NULL,
		clockstatefile, clock_svar_table,
		CLOCK_USER, &sessClk, "S:",
		0,		/* no alarm, update in ms */
		getvar_int("update-interval", clock_svar_table) * 1000);
  x = clock_new(form, "userClk",
		x, NULL,
		clockstatefile, clock_svar_table,
		CLOCK_USER, &userClk, NULL,
		0,				/* no alarm */
		1000);	/* update every 1000ms */
  return(psh ? psh : form);
}

void clockbar_start_userClk(void)
{
  if (userClk)
    clock_reset(userClk, CLOCK_RESTART);
}
