/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: byteorder.h,v 2.43 1996/11/07 18:40:54 bjarthur Exp $
** Program: dowl
**  Module: byteorder.h
**  Author: mazer
** Descrip: interface file for byteorder.c
**
** Revision History (most recent last)
**
*******************************************************************/

#ifdef SWAPBYTES

#define swapint(p)
#define swapshort(p)
#define swapshorts(p, q)

#else /* SWAPBYTES */

extern void _swapint(unsigned char*);
extern void _swapshort(unsigned char*);
extern void _swapshorts(short*, int);

#define swapint(p)	 _swapint(p)
#define swapshort(p)	 _swapshort(p)
#define swapshorts(p, q) _swapshorts(p, q)

#endif /* SWAPBYTES */
