/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: button.c,v 2.48 1999/02/14 05:05:12 bjarthur Exp $
** Program: dowl
**  Module: button.c
**  Author: mazer
** Descrip: wrappers for CommandWidgets, ToggleWidgets and LabelWidgets
**
** Revision History (most recent last)
**
** Sat Feb 29 13:10:28 1992 mazer
**  added toggle_new() and friends -- supports radio groups
**  
** Sun Mar 22 17:02:42 1992 mazer
**  added check_new() and friends -- no readio groups..
**  
** Wed Feb 24 13:08:03 1993 mazer
**  removed LOCK_BUTTON stuff, changed my toggle stuff to
**  just standard toggle buttons.. no more ugly bitmaps
**   - all check_ function are gone -- use toggle's instead
**   - toggle_new() is now togglesvar_new()
**  
** Thu May  5 10:54:20 1994 mazer
**  added XX_new2() functions
**
*******************************************************************/

#include "xdphyslib.h"

static void ToggleSvarCB(Widget, XtPointer, XtPointer);
static void ToggleIntCB(Widget, XtPointer, XtPointer);

Widget button_new(Widget parent, String name, String label,
      XtCallbackProc callback, XtPointer client_data, Widget horiz, Widget vert)
{
  Widget w;

  w = XtVaCreateManagedWidget(name, commandWidgetClass, parent,
			      XtNlabel, 	label,
			      XtNfromHoriz, 	horiz,
			      XtNfromVert, 	vert,
			      NULL);
  if (callback)
    XtAddCallback(w, XtNcallback, callback, client_data);
  return(w);
}

Widget pixbutton_new(Widget parent, Pixmap image, XtCallbackProc callback,
      caddr_t client_data, Widget horiz, Widget vert)
{
  Widget w;

  w = XtVaCreateManagedWidget("button", commandWidgetClass, parent,
			      XtNbitmap,	image,
			      XtNfromHoriz, 	horiz,
			      XtNfromVert, 	vert,
			      NULL);
  if (callback)
    XtAddCallback(w, XtNcallback, callback, client_data);
  return(w);
}

Widget label_new(Widget parent, String label, Widget horiz, Widget vert,
      int border)
{
  return(XtVaCreateManagedWidget(label, labelWidgetClass, parent,
				 XtNlabel, 	label,
				 XtNfromHoriz,	horiz,
				 XtNfromVert, 	vert,
				 XtNborderWidth, border,
				 NULL));
}

Widget pixlabel_new(Widget parent, Pixmap image, Widget horiz, Widget vert,
      int border)
{
  return(XtVaCreateManagedWidget("label", labelWidgetClass, parent,
				 XtNbitmap,	image,
				 XtNfromHoriz,	horiz,
				 XtNfromVert, 	vert,
				 XtNborderWidth, border,
				 NULL));
}

static void ToggleSvarCB(Widget w, XtPointer nameptr, XtPointer call_data)
{
  char *name = (char *) nameptr;
  Boolean state;

  XtVaGetValues(w, XtNstate, &state, NULL);
  SI(name, (int)state);
}

static void ToggleIntCB(Widget w, XtPointer valuepptr, XtPointer call_data)
{
  int *valuep = (int *) valuepptr;
  Boolean state;

  XtVaGetValues(w, XtNstate, &state, NULL);
  *valuep = (int)state;
}

int toggle_get(Widget t)
{
  Boolean s;

  XtVaGetValues(t, XtNstate, &s, NULL);
  return((int)s);
}

void toggle_set(Widget t, int s)
{
  XtVaSetValues(t, XtNstate, (Boolean)s, NULL);
}

Widget toggle_new(Widget parent, String name, String label, Widget horiz,
      Widget vert, Widget radio, XtCallbackProc cb, XtPointer cb_data,
      Boolean state)
{
  Widget w;

  w = XtVaCreateManagedWidget(name, toggleWidgetClass, parent,
			      XtNlabel, 	label,
			      XtNfromHoriz, 	horiz,
			      XtNfromVert, 	vert,
			      XtNradioGroup,	radio,
			      XtNstate,		state,
			      NULL);
  if (cb)
    XtAddCallback(w, XtNcallback, cb, cb_data);
    
  return(w);
}

#if(0)
Widget togglesvar_new(Widget parent, String name, String label, Widget horiz,
      Widget vert, Widget radio, XtCallbackProc cb, caddr_t cb_data)
{
  Widget w;
  extern char *rindex();

  w = XtVaCreateManagedWidget(name, toggleWidgetClass, parent,
			      XtNlabel, 	label,
			      XtNfromHoriz, 	horiz,
			      XtNfromVert, 	vert,
			      XtNradioGroup,	radio,
			      XtNstate,		GI(name),
			      NULL);
  /* NB At some point this needs to be fixed: I think that order of
  **    callback execution is undefined, so the user-fn can't rely on
  **    the state of the svar/int yet
  */
  XtAddCallback(w, XtNcallback, ToggleSvarCB, strsave(name));
  if (cb)
    XtAddCallback(w, XtNcallback, cb, (XtPointer) cb_data);
    
  return(w);
}
#endif

Widget toggleint_new(Widget parent, String name, String label, int *valuep,
      Widget horiz, Widget vert, Widget radio, XtCallbackProc cb,
      caddr_t cb_data)
{
  Widget w;
  char *p, *rindex();

  if ((p = rindex(label, '.')) != NULL)
    p++;
  else
    p = label;

  w = XtVaCreateManagedWidget(name, toggleWidgetClass, parent,
			      XtNlabel, 	p,
			      XtNfromHoriz, 	horiz,
			      XtNfromVert, 	vert,
			      XtNradioGroup,	radio,
			      XtNstate,		*valuep,
			      NULL);
  /* NB At some point this needs to be fixed: I think that order of
  **    callback execution is undefined, so the user-fn can't rely on
  **    the state of the svar/int yet
  */
  XtAddCallback(w, XtNcallback, ToggleIntCB, valuep);
  if (cb)
    XtAddCallback(w, XtNcallback, cb, cb_data);
  return(w);
}

void button_off(Widget w)
{
  if (w) XtSetSensitive(w, False);
}

void button_on(Widget w)
{
  if (w) XtSetSensitive(w, True);
}

void label_set(Widget label, String text)
{
  XtVaSetValues(label, XtNlabel, text, NULL);
}

