/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: atgraph.h,v 2.45 1999/02/02 19:43:05 bjarthur Exp $
** Program: dowl
**  Module: atgraph
**  Author: mazer
** Descrip: interface file for atgraph module
**
** Revision History (most recent last)
**
** Mon Apr  6 16:06:01 1992 mazer
**  creation date
**
*******************************************************************/

#ifndef _atgraph_h_
#define _atgraph_h_

typedef struct {
  Widget plotter;
  Widget xaxis;
  Widget yaxis;
  Widget bars;

  float *bins;
  float *binvals;
  int nbins;
  float binwidth;

  int xlog;
  int ylog;
} ATH;

#define ath_linear	0
#define ath_log		1

extern	void atgraph_quick(char*, char*, char*, int, char **, int*,
      float**, float**, float**, int);

extern 	ATH  *athisto_new(Widget, char*, char*, int, char*, int, int, float);
extern  void  athisto_decay(ATH *h, float kappa);
extern  int	  athisto_add(ATH*, float, int, float);
extern  void  athisto_clear(ATH*);
extern  void  athisto_update(ATH*);

#endif /* _atgraph_h_ */
