/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: atgraph.c,v 2.49 1999/02/02 19:43:05 bjarthur Exp $
** Program: dowl
**  Module: atgraph
**  Author: mazer
** Descrip: xy-graph plotter
**
** Revision History (most recent last)
**
** Sun Jun 27 15:36:42 1993 mazer
**  creation date :: cloned from xygraph.c
**
** Tue Jun 29 15:35:57 1993 mazer
**  added athisto stuff
**
** Tue Sep 14 23:34:41 1993 mazer
**  added lname argument to atgraph_quick()
**
** Sun Oct 10 20:17:42 1993 mazer
**  fixed legend handling code .. it was setting nlines = -1, which
**  meant that nlines > 1 for legends displayed legends when there
**  were more than *2* lines...
**
** Sat Nov 27 23:18:47 1993 mazer
**  added autospline support and line hiding, ditched the use
**  modifiable linestyle crap..
**
** Sun Nov 28 13:37:58 1993 
**   generalized the autospline to "autofit" -- can be splines
**   or n-th degree polynomials..
**
** Sun Jan 23 19:26:17 1994 mazer
**  added atgraph_changecurve() -- note that right now, this fn
**  assumes that the basic TYPE of curve hasn't changed. It
**  basically can change the underlying data only..
**
** Sun Mar  6 15:41:57 1994 mazer
**  added fig/ps stuff from PostScript.c back here to avoid
**  sucking in Wave and Canvas widgets every time you need
**  an atplot..
**
** Thu May 12 18:34:48 1994 mazer
**  added a primitive cut paste between graphs -- any atgraph
**  can be used to "CUT" data, but only apps/xplot can actually
**  paste things in right now..  line style's not preserved..
**
** Tue May 31 16:18:51 1994 mazer
**  added atgraph_title_set() and atgraph_xylabels_set()
**
** Fri Oct 28 15:14:01 1994 mazer
**  changed atgraph_addline() --> atgraph_addlineseg()
**  changed atgraph_offsetline() --> atgraph_offsetcurve()
**
** Wed Feb  1 12:09:09 1995 mazer
**  modifed things for multi plots..
**
** Wed Feb  8 01:07:34 1995 mazer
**  deleted multi plots --> use notepad's instead!
**
** Sun Feb 26 13:55:23 1995 mazer
**  changed print menu item (PrintCB) to use jgraph
**  output..
**
** 98.11 bjarthur
**  added atgraph_quick and deleted most of the other atgraph stuff
**  now using atplotter instead
**
** 99.01 bjarthur
**  added atgraph_decay.  users can now specify an exponential decay
**  rate so only the most recent data is displayed.  don't have to
**  keep hitting clear.
*******************************************************************/

#include "xdphyslib.h"

void atgraph_quick(char *title, char *xl, char *yl, int nlines,
			char **color, int *npts, float **x, float **y, float **z, int skip)
{
	FILE *pptr;
	int i,j;

  if(fork()) {
  	pptr = popen("atplotter","w");

  	for(j=0; j<nlines; j++) {

  		fprintf(pptr,"BEGIN_PARAMS\n");
  		fprintf(pptr,"Title=%s\n",title);
  		fprintf(pptr,"XLabel=%s\n",xl);
  		fprintf(pptr,"YLabel=%s\n",yl);
  		fprintf(pptr,"Class=line\n");
  		fprintf(pptr,"Line=solid\n");
  		fprintf(pptr,"Type=linepoints\n");
  		fprintf(pptr,"Color=%s\n",
  					((color!=NULL) && (color[j]!=NULL)) ? color[j] : "blue");
  		fprintf(pptr,"DataType=AtFloat\n");
  		fprintf(pptr,"Guage=60\n");
  		fprintf(pptr,"X=%d\n",((x==NULL) || (x[j]==NULL)) ? 0 : 1);
  		fprintf(pptr,"Z=%d\n",((z==NULL) || (z[j]==NULL)) ? 0 : 1);
  		fprintf(pptr,"END_PARAMS\n");
  		fprintf(pptr,"BEGIN_DATA\n");
  
  		for(i=0; i<npts[j]; i++) {
  			if((x!=NULL)&&(x[j]!=NULL)) fprintf(pptr,"%f ",x[j][i*skip]);
  			fprintf(pptr,"%f ",y[j][i*skip]);
  			if((z!=NULL)&&(z[j]!=NULL)) fprintf(pptr,"%f ",z[j][i*skip]);
  			fprintf(pptr,"\n"); }
   
  		fprintf(pptr,"END_DATA\n\n"); }
  
  	pclose(pptr);

  	exit(0); }
}

static void hinit(ATH *h, int nbins, float binwidth, int firsttime)
{
  int i;
  double xmin, xmax;
  double offset = 1.0;

  if (firsttime || nbins != h->nbins || binwidth != h->binwidth) {
    h->nbins = nbins;
    h->binwidth = binwidth;
    if (h->bins != NULL)
      free(h->bins);
    if (h->binvals != NULL)
      free(h->binvals);
    h->bins = (float *) calloc(h->nbins, sizeof(float));
    h->binvals = (float *) calloc(h->nbins, sizeof(float));
    for (i = 0; i < h->nbins; i++) {
      h->bins[i] = 0.0;
      h->binvals[i] = i * h->binwidth;
    }
    if (h->xlog == ath_linear)
      xmin = 0.0;
    else
      xmin = 0.1;
    xmax = nbins * h->binwidth;
    XtVaSetValues(h->xaxis,
    		  XtNmin, &xmin, XtNmax, &xmax,
    		  XtNautoScale, False, XtNroundEndpoints, False, NULL);
    XtVaSetValues(h->bars,
          XtNbarOffset, &offset, NULL);
    AtQuadLinePlotAttachData(h->bars,
			   h->binvals, AtFloat, sizeof(float), 
			   h->bins, AtFloat, sizeof(float),
			   NULL, AtFloat, sizeof(float),
			   NULL, AtFloat, sizeof(float), 0, h->nbins);

  }
}

ATH *athisto_new(Widget parent, char *title, char *xlabel, int xlog,
     char *ylabel, int ylog, int nbins, float binwidth)
{
  ATH *h = (ATH *) calloc(1, sizeof(ATH));
 
  h->plotter = 
    XtVaCreateManagedWidget("ath_plotter", atPlotterWidgetClass, parent,
			    XtNtitle, title, XtNshowLegend, False,
                            XtNborderWidth, 0,
			    NULL);
  h->xaxis =
    XtVaCreateWidget("xaxis", atQuadAxisWidgetClass, h->plotter,
		     XtNvertical, False,
		     XtNaxisTransform, xlog == ath_log ?
		     		AtTransformLOGARITHMIC :
			     	AtTransformLINEAR,
		     XtNlabel, xlabel, NULL);

  h->ylog = ylog;
  h->yaxis =
    XtVaCreateWidget("yaxis", atQuadAxisWidgetClass, h->plotter,
		     XtNvertical, True, XtNlabel, ylabel,
		     XtNaxisTransform, ylog == ath_log ?
		     		AtTransformLOGARITHMIC :
			     	AtTransformLINEAR,
		     NULL);
  XtVaSetValues(h->plotter, XtNxAxis, h->xaxis, XtNyAxis, h->yaxis, NULL);

  h->bars = XtVaCreateWidget("bars", atQuadBarPlotWidgetClass, h->plotter, NULL);
  hinit(h, nbins, binwidth, 1);
  return(h);
}

void athisto_decay(ATH *h, float kappa)
{
  int i;
	float mult = exp(-1.0/kappa);

  for(i=0; i<h->nbins; i++)
    h->bins[i] *= mult;
}

int athisto_add(ATH *h, float datum, int nbins, float binwidth)
{
  int bin;

  hinit(h, nbins, binwidth, 0);
  if ((bin = (int)(datum / h->binwidth + 0.5)) < h->nbins) {
    h->bins[bin] += 1.0;
    return(1);
  }
  return(0);
}

void athisto_clear(ATH *h)
{
  int i;

  for (i = 0; i < h->nbins; i++)
    h->bins[i] = 0.0;
}

void athisto_update(ATH *h)
{
  AtQuadLinePlotAttachData(h->bars,
			 h->binvals, AtFloat, sizeof(float), 
			 h->bins, AtFloat, sizeof(float),
			 NULL, AtFloat, sizeof(float),
			 NULL, AtFloat, sizeof(float), 0, h->nbins);
}
