/*
 * Copyright 1991 The University of Newcastle upon Tyne
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose other than its commercial exploitation
 * is hereby granted without fee, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of The University of Newcastle upon Tyne not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. The University of
 * Newcastle upon Tyne makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 * 
 * THE UNIVERSITY OF NEWCASTLE UPON TYNE DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF
 * NEWCASTLE UPON TYNE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 * 
 * Author:  Jim Wight (j.k.wight@newcastle.ac.uk)
 *          Computing Laboratory, University of Newcastle upon Tyne, UK
 */

#ifndef FileNominatorP_h
#define FileNominatorP_h

#define XtCSelectMenu "SelectMenu"
#define XtCShowDotFiles "ShowDotFiles"
#define XtCShowDirs "ShowDirs"
#define XtCBellLevel "BellLevel"
#define XtCPattern "Pattern"
#define XtCDefaultFile "DefaultFile"
#define XtCSelectAction "selectAction"
#define XtCCancelAction "cancelAction"

typedef struct {
    /* resources */
    XtCallbackList      select_callback;
    String              select_menu;
    XtCallbackList      cancel_callback;
    Dimension           margin;
    int                 number_rows;
    Boolean             show_dot_files;
    Boolean             show_dirs;
    int                 bell_level;
    String		pattern;
    String		default_file;
    String		select_action;
    String		cancel_action;
    
    /* private data */
    Widget              viewport_widget;
    Widget              list_widget;
    Widget		filename_widget;
    Widget              select_widget;
    Widget              path_widget;
    Widget		cancel_widget;	
    String              *listList;
    char                currentDir[MAXPATHLEN];
    Boolean             watchingChanges;
    FileNominatorStruct nomination;
    char		*(*annotate_method)();
} FileNominatorPart;

typedef struct _FileNominatorRec {
    CorePart		core;
    FileNominatorPart	fileNominator;
} FileNominatorRec;

typedef struct {
    XtPointer		extension;
} FileNominatorClassPart;

typedef struct _FileNominatorClassRec {
    CoreClassPart	        core_class;
    FileNominatorClassPart	fileNominator_class;
} FileNominatorClassRec, *FileNominatorClass;

extern FileNominatorClassRec fileNominatorClassRec;

#endif /* FileNominatorP_h */

extern String FileNominatorGetDirectory(Widget);
extern void FileNominatorSetDirectory(Widget, String);
