/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: CanvasP.h,v 2.43 1996/11/07 18:40:54 bjarthur Exp $
** Program: dowl
**  Module: CanvasP.h
**  Author: mazer
** Descrip: private header file for Canvas Widget
**
** Revision History (most recent last)
**
*******************************************************************/

#ifndef _CanvasP_h
#define _CanvasP_h

typedef struct {
    int empty;
} CanvasClassPart;

typedef struct _CanvasClassRec {
    CoreClassPart	core_class;
    CanvasClassPart	canvas_class;
} CanvasClassRec;

extern CanvasClassRec canvasClassRec;

typedef struct _CanvasCoord {
  float xmin, xmax;
  float ymin, ymax;
  struct _CanvasCoord *next;
} CanvasCoord;

typedef struct {
  /*
   ** natural resources
   */
  XtCallbackList	input_callback;	/* any sort of button input */
  String		fontname;	/* name of font to use */
  XFontStruct	       *fontinfo;	/* font for text */
  Pixel			foreground_pixel;
  Boolean		update_on_draw;

  /*
   ** private state
   */
  GC			gc;		/* internal gc */
  CanvasObject	       *lineList;	/* list of lines to paint */
  Pixel			current_foreground;

  float			wc_xmin,wc_xmax; /* world coords */
  float			wc_ymin,wc_ymax;

  float			vc_xmin,vc_xmax; /* view coords */
  float			vc_ymin,vc_ymax;
  CanvasCoord	       *vc_stack;
  int			vc_depth;

  float			tmp_xmin,tmp_xmax;
  float			tmp_ymin,tmp_ymax;

  Boolean		mark_lines;

  Pixel			the_pen;	/* private stash.. */

  int			xhair_set;
  int			xhair_px, xhair_py;
  float			xhair_x, xhair_y;
  Boolean		erase_rubber;
  Window		msgwin;
} CanvasPart;

typedef struct _CanvasRec {
    CorePart	core;
    CanvasPart	canvas;
} CanvasRec;


#define XtCUpdateOnDraw		 "UpdateOnDraw"

#endif  _CanvasP_h
