/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: Canvas.h,v 2.43 1996/11/07 18:40:54 bjarthur Exp $
** Program: dowl
**  Module: Canvas.h
**  Author: mazer
** Descrip: canvas widget public interface
**
** Revision History (most recent last)
**
*******************************************************************/

#ifndef _Canvas_h
#define _Canvas_h

/****************************************************************
 *
 * Canvas widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
From Template:
------------------------------------------------------------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

New to Canvas:
------------------------------------------------------------------
 callback	     Callback		Callback	NULL
 foreground	     Foreground		Pixel		XtDefaultForeground
 updateOnDraw	     UpdateOnDraw	Boolean		True

*/

#define XtNpenColor	 "penColor"
#define XtNupdateOnDraw	 "updateOnDraw"

typedef struct _CanvasClassRec*		CanvasWidgetClass;
typedef struct _CanvasRec*		CanvasWidget;
extern WidgetClass			canvasWidgetClass;

typedef enum {
  CanvasLine,
  CanvasPoint,
  CanvasText,
  CanvasRectangle,
  CanvasFilledRectangle,
  CanvasPenColor,
  CanvasVerticalText,
  CanvasCircle,
  CanvasFilledCircle,
  CanvasPoints
} CanvasTypecode;

typedef enum { CanvasDataFloat, CanvasDataInt, CanvasDataShort } CanvasData;

#define CanvasTextLeft	 	1
#define CanvasTextHCenter	2
#define CanvasTextRight		4
#define CanvasTextTop		8
#define CanvasTextVCenter	16
#define CanvasTextBottom	32
#define CanvasTextCenter	(CanvasTextHCenter | CanvsTextVCenter)

#define CanvasFix		0
#define CanvasFloatX		1
#define CanvasFloatY		2
#define CanvasFloatWidth	4
#define CanvasFloatHeight	8

typedef struct _CanvasObject {
  /* data for ALL object types */
  CanvasTypecode	typecode;
  int		 	x1, y1;
  float			fx1, fy1;
  int		 	style;
  int		 	line_width;

  int			rescale;
  int			float_or_fix;
  struct _CanvasObject *next;
  struct _CanvasObject *prev;

  /* specialized members */
  union {
    Pixel		pen;
    struct {
      int	 	x2, y2;
      float		fx2, fy2;
    } point2;
    struct {
      int 		width;
      int 		height;
      char             *string;
    } text;
    struct {
      Boolean		connect;
      int		npoints;
      float	       *fxvals, *fyvals;
      XPoint           *ptdata;
    } points;
  } u;
} CanvasObject;


extern CanvasObject *XtCanvasAddPoint(CanvasWidget, float, float, int);
extern CanvasObject *XtCanvasAddLine(CanvasWidget, float, float, float,
      float, int, int, int);
extern CanvasObject *XtCanvasAddPoints(CanvasWidget, CanvasData, int, int,
      void*, int, float, void*, int, float, int);
extern CanvasObject *XtCanvasAddText(CanvasWidget, float, float, char*, int,
      int);
extern CanvasObject *XtCanvasAddVerticalText(CanvasWidget, float, float, char*,
      int, int);
extern CanvasObject *XtCanvasAddRectangle(CanvasWidget, float, float, float,
      float, int, int, int);
extern CanvasObject *XtCanvasAddFilledRectangle(CanvasWidget, float, float,
      float, float, int, int, int);
extern CanvasObject *XtCanvasAddCircle(CanvasWidget, float, float, float, float,
      int, int, int);
extern CanvasObject *XtCanvasAddFilledCircle(CanvasWidget, float, float, float,
      float, int, int, int);
extern CanvasObject *XtCanvasPenColor(CanvasWidget, Pixel);

extern int	     XtCanvasDeleteObject(CanvasWidget, CanvasObject*);

extern void	     XtCanvasClear(CanvasWidget, int);
extern void          XtCanvasPS(CanvasWidget, char*, char*);

extern void	     XtCanvasSetWC(CanvasWidget, float, float, float, float);
extern void	     XtCanvasGetWC(CanvasWidget, float*, float*, float*,
                           float*);

extern void	     XtCanvasClearVC(CanvasWidget);
extern void	     XtCanvasUpdate(CanvasWidget);
extern void	     XtCanvasSetVC(CanvasWidget, float, float, float, float);
extern void	     XtCanvasGetVC(CanvasWidget, float*, float*, float*,
                           float*);

extern Widget	     XtCanvasFind(Widget);
extern void 	     XtCanvasXYtoWC(CanvasWidget, int, int, float*, float*);
extern int	     XtCanvasUserView(CanvasWidget);
extern int	     XtCanvasXhair(CanvasWidget, float*, float*, int*, int*,
                           int);

extern CanvasObject *XtCanvasNearestObject(CanvasWidget, int, int, int);
extern void	     XtCanvasToggleFill(CanvasWidget, CanvasObject*);

extern void	     XtCanvasSetMsg(CanvasWidget, char*);

#endif  _Canvas_h
