% function x = xdview_rasters_presorder(filename,mask)
%
% OUT = XDVIEW_RASTERS(filename)
% 
% puts rasters returned by fdread.m into the following structure:
%
% main struct
% OUT.nrasters            total number of rasters
% OUT.epoch               epoch in milliseconds
% OUT.rasters()           array of RASTER records
%
% RASTER record:
% RASTER.nspikes          number of spikes in this raster
% RASTER.depint           depint for this raster
% RASTER.spikes()         array of spike times in milliseconds
% RASTER.type()           spike model number in for each spike in spikes() 


function out = xdview_rasters_presorder(filename)

fd = fdread(filename);

% put the output of fdread into a nice structure

out.nrasters=fd.nrasters;
out.epoch=fd.epoch;

rastnum=fd.rasters(1,1);
out.rasters(1).nspikes=1;
out.rasters(1).depint=fd.rasters(1,4);
out.rasters(1).spikes(1)=fd.rasters(1,2)/10000;
out.rasters(1).type(1)=fd.rasters(1,3);
j=1;
k=1;
x=size(fd.rasters);
totspikes=x(1,1);
for i=1:totspikes,
	if (fd.rasters(i,1) ~= rastnum),
		rastnum=fd.rasters(i,1);
		j=j+1;
		k=1;
		out.rasters(j).depint=fd.rasters(i,4);
		if (fd.rasters(i,2)==-1),
			out.rasters(j).nspikes=0;
			out.rasters(j).spikes=[];
			out.rasters(j).type=[];
			continue;
		else
			out.rasters(j).nspikes=1;
		end
	else
		k=k+1;
		out.rasters(j).nspikes=out.rasters(j).nspikes+1;
	end
	out.rasters(j).spikes(k)=fd.rasters(i,2)/10000;
	out.rasters(j).type(k)=fd.rasters(i,3);
end

