% function x = xdview_isih(filename,mask)
%
% a new breed of xdview_.*.m functions.  this departs from earlier
% ones in that it has xdview dump the raw raster data, and then
% compute the isih from that.  this is the first step in the right
% direction to porting xdview (and later on xdphys) to matlab.
%
% returns vector of ISIs across all rasters in 1/10ths of ms

function x = xdview_isih(filename,mask)

fd = fdread(filename);

% Remove empty trials from fd.rasters
idx=find(fd.rasters(:,2)==-1);
fd.rasters=fdrasters(idx,:);

idx = find(fd.rasters(:,3)==mask);
foo = fd.rasters(idx,:);

% workaround xdphys bug, now fixed
idx = find(foo(:,2)>=0);
foo = foo(idx,:);

e = diff(foo);
f = find(e(:,1)==0);
x = e(f,2);
