% function [x,y,e,s,n] = xdview_curve(filename)
%
% use xdview to read filename and get curve view data
% x = depvals, y = means, e = stderrs, s = spont [mean stderr n], n = # reps

% one could imagine similar functions, like xdview_[raster,psth,isih,...]

function [x,y,e,s,n] = xdview_curve(filename)

[s,w] = unix(['xdview -curve -text ' filename]);
if(strcmp(w,''))
  filename = cat(2,filename,'.gz');
  [s,w] = unix(['xdview -curve -text ' filename]);
end

t = findstr(w,'RASTERDATA');
j=18;
while ~isspace(w(t(1)+j)) j = j+1; end
n = sscanf(w(t(1)+18:t(1)+j),'%f');

while isspace(w(t(1)+j)) j = j+1; end
d = sscanf(w(t(1)+j:t(2)-6),'%f');
d = reshape(d,length(d)/n,n);
d = d';

x = d(:,1);
y = d(:,2);
if size(d,2) > 3
	e = d(:,3);
end
n = d(:,end);

%%%%% old method of getting n
%t = findstr(w,'Reps=');
%tt = findstr(w(t(1)+5:end),char(10));
%n = sscanf(w(t(1)+5:t(1)+5+tt(1)),'%f');

t = findstr(w,'spont=');
tt = findstr(w(t(1)+6:end),char(10));
s = sscanf(w(t(1)+6:t(1)+6+tt(1)),'%f');
