% function plotana2(file,adfc,pre,post,maxn,mode)
%
% file is the xdphys file with analog data
% adfc is the sampling rate in ticks/sec
% pre and post specify how many milliseconds to display
% plots only maxn spikes
% mode = 1 means plot peak at zero; = 0 or unspecified means plot threshold
%    crossing at zero.

function plotana2(file,adfc,pre,post,maxn,mode)

if(nargin<6)
  mode = 0;
end

d = readana(file);
n = fdread(file);

% Remove empty trials from fd.rasters
idx=find(fd.rasters(:,2)==-1);
fd.rasters=fdrasters(idx,:);

% first, undo crazy format
% I'm sure you meant efficient, logical format -- CPM 

k=0;
for i = 1:length(d)
  for j = 1:length(d(i).rasternums)
    k=k+1;
    dd(k).trace = d(i).traces(:,j);
    dd(k).rasternum = d(i).rasternums(j);
  end
end

pre = pre*1e-3*adfc;
post = post*1e-3*adfc;

clf reset
hold on
k=0;
thresh=1e6;
for i = 1:length(dd)
  n.rasters(:,1)==dd(i).rasternum;
  ts = n.rasters(ans,2);
  ts = ts*1e-7*adfc;
  ts = ts + 1;
  for j = 1:length(ts)
    k=k+1;

    if(mode==1)
      maxx = find(diff( dd(i).trace(round(ts(j)):end ))<0);
      maxx = maxx(1) - 1;

      ym = dd(i).trace(round(ts(j))+maxx);
      yl = ym - dd(i).trace(round(ts(j))+maxx-1);
      yr = ym - dd(i).trace(round(ts(j))+maxx+1);
      offx = maxx + (yl-yr)/(yl+yr)/2;
      foo = (maxx-2):(maxx+2);
      offy = 0; %my_cubic_interp(dd(i).trace(round(ts(j))+foo),offx-(maxx-2)+1);
    else
      offx = 0;
      offy = 0;
    end

    from = max([1 round(ts(j)-pre)]);
    to = min([length(dd(i).trace) round(ts(j)+post)]);
    x1 = -pre + (from-round(ts(j)-pre));
    x2 = post - (to-round(ts(j)+post));

    plot([(x1:x2) - offx]/adfc*1e3,dd(i).trace(from:to)-offy);
    thresh = min([thresh dd(i).trace(round(ts(j)+1))]);
    if(k==maxn)
      break;
    end
  end
  if(k==maxn)
    break;
  end
end

if(mode == 0)
  plot([-pre post]/adfc*1e3,[thresh thresh],'r');
end


function f = my_cubic_interp(y,u)

s = (u - floor(u));
u = floor(u);
s2 = s.*s; s3 = s.*s2;
f = y(u-1).*(-s3+2*s2-s) + y(u).*(3*s3-5*s2+2) + ...
    y(u+1).*(-3*s3+4*s2+s) + y(u+2).*(s3-s2);
f = f/2;
