% function d = nspikes(filename)

function d = nspikes(filename)

[s,w] = unix(['xdview -nspikes ' filename ' 2>/dev/null']);
if(strcmp(w,''))
  filename = cat(2,filename,'.gz');
  [s,w] = unix(['xdview -nspikes ' filename ' 2>/dev/null']);
end
if(strcmp(w,''))
  error('problems reading file.');
end

d=0;
i=1;
[t,w] = strtok(w,10);
while(~isempty(t))
  tmp=findstr(t,'> ');
  if(isempty(tmp))
    tmp=findstr(t,' ');
    f=t(1:tmp-1);
    tmp = tmp-1;
  else
    t2=t(2:tmp-1);
    if(strcmp(t2,'SPONT'))
      f = -6666;
    else
      for j=1:5, [f,t2]=strtok(t2,';'); end
      if(strncmp(f,'STACK=',6))
        f=f(7:end);
        if(sum(findstr(f,':')))
          f=strrep(f,':',' ');
          foo=sscanf(f,'%d');
          f = foo(1) : foo(3) : foo(2);
        else
          f=strrep(f,',',' ');
          f=strrep(f,'(',' ');
          f=strrep(f,')','');
          f=sscanf(f,'%d')';
        end
      elseif(strcmp(f,'BB') | strcmp(f,'HP') | strncmp(f,'[',1))
        f = 0;
      else
        f = sscanf(f,'%d');
      end
    end
  end

  bar = cat(2,'f',num2str(i));
  d = setfield(d,bar,f);

  t2=t(tmp+2:end);
  tns = sscanf(t2,'%d')';

  bar = cat(2,'ns',num2str(i));
  d = setfield(d,bar,tns);

  [t,w] = strtok(w,10);
  i=i+1;
end

d = setfield(d,'n',i-1);
