function data=depvars(file)
% USAGE: DEP = DEPVARS('FILENAME');
%
%	Returns a vector of unique depvars in xdowl analog datafile FILENAME.
%
% $Id: depvars.m,v 1.1 1997/03/04 22:03:20 cmalek Exp $

% The header struct is:
%
%  int        magic
%  int        fc
%  int        nsamps
%  int        nchans
%  char[100]  comment
%  int        bits
%  char[20]   program
%  char[20]   arch
%  int        tomv
%  int        tomv_div
%  int        offset
%  int        offset_div
%  char[336]  padding

%  it's 512 bytes long, and is described in dowl/libsrc/include/waveio.h
%  xdowl is probably compiled to align structs along 4 byte boundries,
%  so types with size < 4 get converted to 4 bytes in the header.

%----------------------
% Set some variables
%----------------------

fid=fopen(file, 'r', 'b');
if fid == (-1),
	error(['Unable to open file ', filename]);
end;

[magic,count] = fread(fid,1,'int');
%if magic ~= 22321,
%	error('Not an xdowl datafile.');
%end;

disp(sprintf('Looking for depvars in %s ...', file));

disp(' ');
data=[];
while count == 1,
    pad = fread(fid,1,'int');
    nsamps = fread(fid,1,'int');
    nchans = fread(fid,1,'int');
    %disp(sprintf('# channels was %d ...', nchans));
    trace_depvar=sscanf(setstr(fread(fid,100,'char')'),'depvar=%d');
    if isempty(find(data == trace_depvar)) == 1,
	data = [data trace_depvar];
    end;
    pad=fread(fid,198+(nsamps*nchans),'short');
    [magic, count] = fread(fid,1,'int');
end;

data=sort(data);
disp(sprintf('Found %d different depvars', length(data)));

 
