function [RBOB,REOB,RSOB]=call_spkburst(InMatrix,Marker1,Marker2,Marker3,varargin)
%This program calculates the burst parameters of multiple trials by calling SPK_BURST.  
%
% Example:
%     [RBOB,REOB,RSOB]=call_spkburst(InMatrix,Marker1,Marker2,Marker3 
%                                     [,PlotPause])
%
% INPUTS:
%		InMatrix : 
%           Matrix of Timestamps for all trials. 
%           Rows are Trials and Columns are Spiketimes in ms
%
%		Marker1, Marker2 :  
%           Time limits for computing average Spike Rate for analyzing 
%           the complete spike train for a given trial.
%
%           NOTE: Burst results may not be valid outside limits.
%
%		    Values for Marker1 and Marker2: 
%                Vector with No. of rows equal to No. of rows in InMatrix.
%
%		         Scalar values for Marker1 and Marker2 specify a 
%                constant window for all trials. This is useful when 
%                spike times are relative to a fixed event.
%			     NOTE: padded 0s in the aligned spike times must be set to NaN. 
%
%		Marker3 : 
%           Useful for marking the time of an event on the raster display.
%
%       PlotPause : Flags whether to pause after each plot. 
%                   Can be any number or character.
%
% OUTPUTS:
%		RBOB: A row vector of times for Begining Of Burst.
%		REOB: A row vector of times for End Of Burst.
%		RSOB: A row vector of Surprise Of Burst.
%
% PROBLEMS:
%		If you get an error message as "One or more output arguments 
%		not assigned during call to 'distchck'"
%		Make sure that ROWS are TRIALS
%
% BURST DETECTION PARAMETERS:
%	Must be set in the FIRST part of SPK_BURST function that is called 
%   by this function.
%
% Author:
%   chenchal.subraveti@vanderbilt.edu


%MODIFICATION HISTORY:
%		FEB/11/98: axis limits for plot. x-axis =0 to max(spiketimes for the trial,
%		Marker1,Marker2,Marker3)

Plot_Pause=0;
if nargin==5
	Plot_Pause=1;   
end

%Verify Inputs
%Marker1
if size(Marker1,1)==0 %empty
   Marker1=repmat(0,size(InMatrix,1),1);
elseif size(Marker1,1)==1
   Marker1=repmat(Marker1,size(InMatrix,1),1);
else
end

%Marker2
if size(Marker2,1)==0 %empty
   Marker2=max(InMatrix,[],2);
elseif size(Marker2,1)==1
   Marker2=repmat(Marker2,size(InMatrix,1),1);
else
end

%Marker3
if size(Marker3,1)==0 %empty
   Marker3=max(InMatrix,[],2);
elseif size(Marker3,1)==1
   Marker3=repmat(Marker3,size(InMatrix,1),1);
else
end

%Verify Marker1<Marker2
if max(Marker2(:,1)-Marker1(:,1))<0 
   Marker1=repmat(0,size(Marker2,1),1);
   disp('FROM time > TO time. Changing From time to 0 for all trials');
end

[TotTrls,maxtstamps]=size(InMatrix);
%Check for no of rows in all 3 input matrices
if(max([size(Marker1,1) size(Marker2,1)]==TotTrls))
   %Replace all NaNs with '0'
   XX=Marker1;
   XX(setdiff(find(XX),find(XX>=1)))=0;
   Marker1=XX;
   XX=Marker2;
   XX(setdiff(find(XX),find(XX>=1)))=0;
   Marker2=XX;
   %start for each trial
   RBOB=[];REOB=[];RSOB=[];TrlBOB=[];TrlEOB=[];TrlSOB=[];
   FrmT=0;ToT=0;minT=0;maxT=0;sTrain=[];
   OffsetIndex=0;
   for trl=1:TotTrls
      if(~isempty(nonzeros(InMatrix(trl,:))))
         sTrain=0;FromT=0;ToT=0;
         disp(repmat(['*'],1,80))
         disp(['DOING TRIAL ::::   ',num2str(trl),'  of  ',num2str(TotTrls)])                 
         sTrain=(InMatrix(trl,:));
         sTrain=sTrain(find(sTrain>0));
         FromT=Marker1(trl,1);
         ToT=Marker2(trl,1);
         [TrlBOB,TrlEOB, TrlSOB]=spk_burst(sTrain,FromT,ToT);
         if(isempty(TrlBOB) |isempty(TrlEOB) | ~TrlBOB | ~TrlEOB)
            clf
         end
         RBOB(trl,1:length(TrlBOB))=TrlBOB;
         REOB(trl,1:length(TrlEOB))=TrlEOB;
         RSOB(trl,1:length(TrlSOB))=TrlSOB;
         %plot Marker locations for curent trial
         if(Marker1(trl,1)>=1)
            %axis([Marker1(trl,1)-100 Marker1(trl,1)+300 0 2]);
            %grid
            gcf;
            axis([0 max([max(sTrain);max([Marker1(trl,1) Marker2(trl,1) Marker3(trl,1)])]) 0 2]);
            h=line([Marker1(trl,1) Marker1(trl,1)],[-5 5]);
            set(h,'color',[1 0 0],'linestyle',':');
            h=text(Marker1(trl,1)+10,0.2,'M1');
            set(h,'color',[0 0 0]);
         end
         if(Marker2(trl,1)>=1)
            h=line([Marker2(trl,1) Marker2(trl,1)],[-5 5]);
            set(h,'color',[0 0 1],'linestyle',':');
            h=text(Marker2(trl,1)-50,0.3,'M2');
            set(h,'color',[0 0 0]);
         end
         if(Marker3(trl,1)>=1)
            %h=line([Marker3(trl,1) Marker3(trl,1)],[-5 5]);
            %set(h,'color',[1 0 1],'linestyle',':');
            h=plot([Marker3(trl,1) Marker3(trl,1)],'x');
            set(h,'color',[1 0 1]);
            h=text(Marker3(trl,1)-50,0.4,'M3');
            set(h,'color',[0 0 0]);
         end
         h=text(20,1.3,['Trial No : 'num2str(trl) ' of ' num2str(TotTrls)]);
         set(h,'color',[0 0 0]);
         clear h
         %xlim=[];
         %xlim=[Marker1(trl,1)-50, max(get(gca,'xlim'))];
			%set(gca,'xlim',xlim);
         drawnow
         if(Plot_Pause)
            pause   
         end
      end
   end%for 
else
   disp('Total No of ROWS (Trials) in input Variables are not same!!!')
   disp('Exiting...')
end

