function lat=calc_latency(filename,start,stop,mask)
% USAGE: LAT = CALC_LATENCY('FILENAME',START,STOP);
%        LAT = CALC_LATENCY('FILENAME',START,STOP,MASK);
%
%
% Calculate the latency for "bursts" in the rasters of 'FILENAME'.  Reads
% xdphys datafile 'FILENAME', and calls CALL_SPKBURST to do the real work.
%
% Inputs:
%
%	FILENAME:  an xdphys data file, e.g. '576.01.01.itd'
%   START:     time in the epoch at which to start analysis (milliseconds)
%   STOP:      time in the epoch at which to end analysis (milliseconds)
%   MASK:      spike mask (only useful if you used the Lewicki spike sorter
%                          while gathering data)
%
%
% Outputs:
%
%   LAT:       a matrix of burst start times.  Columns are bursts in
%              the same raster, Rows are rasters.
%
% Example:
% 
% >> lat = calc_latency('576.01.01.itd',100,110);
%
%
% SEE ALSO: CALL_SPKBURST, SPK_BURST, XDVIEW_RASTERS_PRESORDER

if(nargin<2)
  mask = -1;
end

fd=xdview_rasters_presorder(filename);
disp(fd);
fd=xdview_raster_offset(fd,start);

% find max # spikes build matrix

maxspikes=-999;

for i=1:fd.nrasters,
	if (fd.rasters(i).nspikes > maxspikes),
		maxspikes=fd.rasters(i).nspikes;
	end
end

% build matrix for call_spkburst

spike_mat=ones(fd.nrasters,maxspikes);
spike_mat=spike_mat*NaN;

for i=1:fd.nrasters,
	if (fd.rasters(i).nspikes~=0), 
		for j=1:fd.rasters(i).nspikes,
			spike_mat(i,j)=fd.rasters(i).spikes(j);
		end
	end
end


[lat,eob,sob]=call_spkburst(spike_mat,0,stop-start,0);

