#!/usr/bin/gawk -f

# takes .gen files and converts to .itd, .iid, ... files as specified
# syntax: mod_gen_gawk -v sep_files=??? filename filename
# it's a two pass algorithm so the filename must be specified twice
# sep_files can be abi, itd, iid, bc, or bf, and specifies what file
# type to convert the .gen file to

BEGIN {
	FS = "="
	pass_num = 1
	print_em = -1
	version = "1.1.1"
	nspont_trials = 0

	if(pass_num == 1) {
		if (sep_files == "abi")      { type = 1 }
		else if (sep_files == "itd") { type = 2 }
		else if (sep_files == "iid") { type = 3 }
		else if (sep_files == "bc")  { type = 4 }
		else if (sep_files == "bf")  { type = 5 }
		suffix = "." sep_files 
	}
}

{
	if(FNR == 1) {
		xdphys_file = match($0,/^;; [xd]/);
		if (xdphys_file == 0) {
			print "not an xdphys data file" > "/dev/stderr"
			exit 
		}

		if(pass_num == 1) {
			num_outfiles=0
			base = FILENAME
			# strip off the extension
			sub(/\.[^.]*$/,"",base) 
		} else {
			if(num_outfiles==1) {
				sub(/\.[0-9]*\.[^.]*$/,"",filename[0]);
				filename[0] = filename[0] suffix 
			}
			for(i=0; i<num_outfiles; i++) {
				printf "%s%s\n", filename[i], base_stim_array[i] 
			}
			sub("gen", substr(suffix,2)) 
		} 
	}
}

/^COMMENTS$/ {
	if(pass_num == 2) {
		for(i=0; i<num_outfiles; i++) {
			print $0 > filename[i]
			printf ";;this file was derived from %s\n", FILENAME > filename[i]
			printf ";;automatically by mod_gen.gawk ver %s\n", version > filename[i] 
		}
   		next 
	}
}

/^gen\./ {
	if(pass_num == 2) {

		foo = substr($1,1+index($1,"."))
		if (foo == "abi")       { bar = 1 }
	    else if (foo == "itd")  { bar = 2 }
	    else if (foo == "iid")  { bar = 3 }
	    else if (foo == "bc")   { bar = 4 }
	    else if (foo == "stim") { bar = 5 }
	    else if (foo == "mono") { bar = 6 }
	    else if (foo == "two_snd") { bar = 7 }
	    else if (foo == "sep_files") { next }

		for(i=0; i<num_outfiles; i++) {
			split(full_depvar_line[i],tmp,";");

			if(type == 1) {
				if(match($1,"abi")) {
					printf "abi.range=%s\n", $2 > filename[i] 
				} else {
					printf "abi.%s=%s\n", foo, tmp[bar] > filename[i] 
				} 
			}
			if(type == 2) {
				if(match($1,"itd")) {
					printf "itd.range=%s\n", $2 > filename[i] 
				} else if(match($1,"mono")) { 
					# do nothing
				} else {
					printf "itd.%s=%s\n", foo, tmp[bar] > filename[i] 
				} 
			}
			if(type == 3) {
				if(match($1,"iid")) {
					printf "iid.range=%s\n", $2 > filename[i] 
				} else if(match($1,"mono")) { 
					# do nothing
				} else {
					printf "iid.%s=%s\n", foo, tmp[bar] > filename[i] 
				} 
			}
			if(type == 4) {
				if(match($1,"bc")) {
					printf "bc.range=%s\n", $2 > filename[i] 
				} else if(match($1,"mono")) { 
					# do nothing
				} else {
					printf "bc.%s=%s\n", foo, tmp[bar] > filename[i] 
				} 
			}
			if(type == 5) {
				if(match($1,"stim")) {
					printf "bf.range=%s\n", $2 > filename[i] 
				} else {
				  printf "bf.%s=%s\n", foo, tmp[bar] > filename[i] 
				} 
			}
		}

		next 
	}
}

/^depvar/ {
	if(match($2,"gen") != 0) {
		if((type == 1) || (type == 3)) {
			xlabel = sep_files " (dB)" 
		}
		if(type == 2) {
			xlabel = sep_files " (us)" 
		}
		if(type == 4) {
			xlabel = sep_files " (%)" 
		}
		if(type == 5) {
			xlabel = sep_files " (Hz)" 
		}
		sub("gen", xlabel) 
	} else if(match($2,"6666") != 0) {
		if(pass_num == 1) {
			nspont_trials = nspont_trials + 1
		} else if(pass_num == 2) {
			print_em = -1 
		} 
	} else {
		line = $0
		sub(/.*</,"",$0) # strip off the leading <
		sub(/>/,"",$0)   # strip off the trailing >
		# we're left with a ; separated list of values ... split 
		# this out into an array: stim
		split($0,stim,";") 

		base_stim = ""
		# We know there will be seven stim parameters
		# Make a list of stim parameters minus the one we're sorting on
		for(i=1; i<8; i++) {
			if(type != i) {
				base_stim = base_stim "; " stim[i] 
			} 
		}

		if(pass_num == 1) {
			# If pass_num == 1, we're just num_outfilesing stimuli
			if (base_stim in outfiles) { 
				ndepvar_trials[base_stim] = ndepvar_trials[base_stim] + 1
			} else {
				outfiles[base_stim] = num_outfiles
				full_depvar_line[num_outfiles] = $0
				ndepvar_trials[base_stim] = 1
				base_stim_array[num_outfiles] = base_stim
				filename[num_outfiles] = base "." num_outfiles suffix
				num_outfiles = num_outfiles + 1 
			} 
		} else if(pass_num == 2) {
			# If pass_num == 1, we're writing traces 
			# to the output files
			print_em = outfiles[base_stim]
			depvar_line = sprintf("depvar=%s",stim[type])
			sub(/depvar=[0-9]*/,depvar_line,line)
			printf line "\n" > filename[print_em]
			next 
		}
    $0 = line 
	}
}

/^nrasters/ {
	if(pass_num == 2) {
		for(i=0; i<num_outfiles; i++) {
			tmp_stim=base_stim_array[i]
			nrasters=ndepvar_trials[tmp_stim]+nspont_trials
			printf "nrasters=%d\n", nrasters > filename[i] 
		}
		next 
	}
}

/^END_RASTERDATA$/ {
	if(pass_num == 1) {
		pass_num = 2
		nextfile 
	} else {
		print_em = -1 
	}
}

{
	if(pass_num == 2) {
		if(print_em == -1) {
			for(i=0; i<num_outfiles; i++) {
				print $0 > filename[i] 
			} 
		} else {
			print $0 > filename[print_em] 
		} 
	}
}
