%define Version 1.0.20
%define Release 1

Summary		: The synth package provides stimulus synthesis routines 
Name		: synth
Version		: %{Version}
Release		: %{Release}
Group		: Applications/Scientific

Copyright	: GPL
Packager	: cmalek@etho.caltech.edu (Chris Malek)

BuildRoot	: /tmp/synth-%{Version}

Source		: ftp.etho.caltech.edu:/pub/xdphys/SOURCES/synth-%{Version}.tar.gz

%description
The synth package provides sound synthesis routines to produce 
intensity calibrated auditory stimuli.  A C library for linking 
with C programs and a MEX file for use with MATLAB are both provided.
Both the C library and MEX file control tdtproc, a process
which interacts with the DAQ equipment.  The MEX file is no longer
included.

%prep
%setup -n synth

%build
make 

%install
DESTDIR=$RPM_BUILD_ROOT; export DESTDIR
[ -n "`echo $DESTDIR | sed -n 's:^/tmp/[^.].*$:OK:p'`" ] && rm -rf $DESTDIR ||
(echo "Invalid BuildRoot: '$DESTDIR'! Check this .spec ..."; exit 1) || exit 1

for dir in usr/local/lib usr/local/include; do
	install -m 755 -d $DESTDIR/$dir
done

INSTALL_ROOT=$DESTDIR/usr/local; export INSTALL_ROOT
make -e install

%post
/sbin/ldconfig /usr/local/lib

%files
%defattr(-,root,root)
/usr/local/lib/libsynth.a
/usr/local/lib/libsynth.so.1.0.1
/usr/local/include/synth/synth.h
/usr/local/include/synth/calib.h
/usr/local/include/synth/cache.h
/usr/local/include/synth/stimarray.h
/usr/local/include/synth/misc.h
