/*
 * ** This file is part of XDowl
 * ** Copyright (c) 1994 Jamie Mazer
 * ** California Institute of Technology
 * ** <mazer@asterix.cns.caltech.edu>
 */

/******************************************************************
**  RCSID: $Id: synth.h,v 1.10 2005/01/30 09:49:36 bjorn Exp $
** Program: xdphys
**  Module: synth.h
**  Author: mazer
** Descrip: header for synth.c
**
** Revision History (most recent last)
**
** Tue Oct 13 12:52:38 1992 mazer
**  creation date
**
*******************************************************************/

#ifndef _SYNTH_H_
#define _SYNTH_H_

/* RANGE here indicates converters can handle and/or generate data
 * **  on of the order [-RANGE:+RANGE] or [-FRANGE:+FRANGE] */
#define RANGE 	((1 << (NBITS - 1)) - 1)
#define FRANGE	((float) RANGE)

/* frange(s) scales s = [-1.0:1.0] to s = [-FRANGE:+FRANGE] */
#define frange(s) (((s) >= 0.0) ? FRANGE*(s) : FRANGE*(s))

/* overflow(s) checks to see if s is out of converter range */
#define overflow(s) (((s) > FRANGE) || ((s) < -FRANGE))

#define NBITS 16

#define SYN_LEFT   (1 << 0)
#define SYN_RIGHT  (1 << 1)
#define SYN_BOTH   (SYN_LEFT | SYN_RIGHT)
#define SYN_NEITHER (SYN_LEFT & SYN_RIGHT)

#define SYN_MAX_DESCR_LEN  100

typedef enum {
	SC_SILENCE,
	SC_TONE,
	SC_STACK,
	SC_SWEEP,
	SC_NOISE,
	SC_TWO,
	SC_CLICK,
	SC_HEMICLICK,
	SC_INVALID
} syn_class;

typedef struct {
	syn_class class;
  char descr[SYN_MAX_DESCR_LEN];
	union {
		struct {
			float freq;
		} tone;
		struct {
			int num_freqs;
			float *freqs;
			float *iids;
		} stack;
		struct {
			float low, high;
			int n;
		} sweep;
		struct {
			float low, high, res;
		} noise;
		struct {
			int nsamples;  /* # samples that the click is at 1 */
			int type;  /* "condensation" (0) or "rarefaction" (1) click */
		} click;
		struct {
			float freq;
		} hemiclick;
	} parms;

	float lrms, rrms;							/* the scale factor to set the atten's */
	/* to to keep the rms power constant. */
} syn_spec;

extern int syn_calibrate;
extern int (*syn_use_cache)(void);
extern int (*syn_tone_rad_vary)(void);
extern int (*syn_stack_rms)(void);
extern int syn_tone_fixed_phase;

extern float (*syn_bb_low_freq)(void);
extern float (*syn_bb_high_freq)(void);

extern int (*syn_dafc)(void);
extern double (*syn_get_rad)(void);

extern int syn_transfer_to_outbuf(float *, xword *, int, int);

extern char *synthesize_help(void);
extern int syn_spec_parse(char *, int, syn_spec *);
extern void syn_spec_free(syn_spec *);
extern void syn_spec_copy(syn_spec *, syn_spec *);
extern int syn_spec_same(syn_spec *, syn_spec *);

extern int syn_silence(float *, int, float *, float *, int, int);
extern int syn_tone(float *, int, float, int, float *, float *, int, int);
extern int syn_hemiclick(float *, int*, float, int,  float *, float *, int, int);
extern int syn_click(float *,int *,int,int,int,int,int);
extern int syn_stack(float*, int, float*, float*, int, long*, int,
			float *, float *, int, int);
extern int syn_sweep(float *, int, float, float, float, int,
			float *, float *, int, int);
extern int syn_noise_fft(float*, int, long*, int, float, float, float*,
			float*, float*, int, int);
extern int syn_noise(float*, int, long*, int, float, float, int, float*,
			float*, float*, int, int);

extern void two_sound_synthesize(syn_spec*, float*, xword*, int, int, int, int,
			float, float,
			syn_spec *, int, int, int, int, int, int, int,
			syn_spec *, int, int, int, int, int, int, int);
extern void synthesize(syn_spec*, float*, xword*, int, int, int, int, int, int,
			int, int, int, int);

#endif /* _SYNTH_H_ */
