function synth_test(filename, spec, db)
[f,m,p]=xdview_getcal(filename);
set_calib(f,m',p');
[f2,m2,p2]=get_calib;
if all(f2==f),
	disp('Freqs OK');
else
	disp(f);
	disp(f2);
end
if all(floor(m2)==floor(m')),
	disp('Mags OK');
else
	m2
	m'
end

p3(:,1)=unwrap(p(:,1));
p3(:,2)=unwrap(p(:,2));
if all(floor(p2)==floor(p3')),
	disp('Phases OK');
else
	disp(p2);
	disp(p3');
end

[d,a]=synthesize(spec,100,0,0,5,5,db,db,'both');

subplot(2,1,1);
plot(d(:,1),'g');
subplot(2,1,2);
plot(d(:,1),'r');

disp(a);
%---------------------------------
function p=unwrap(x)

p=x;

while (p(1) > pi)
	p(1) = p(1) - 2*pi;
end

while (p(1) < -pi)
	p(1) = p(1) + 2*pi;
end

i=1;
while (i<length(p)),
	while (abs(p(i)-p(i+1))>pi),
		if ((p(i)-p(i+1)) > pi), 
			p(i+1) = p(i+1) + 2*pi;
		elseif ((p(i)-p(i+1)) < -pi),
			p(i+1) = p(i+1) - 2*pi;
		end
	end
	i=i+1;
end

