function [data,att]=synthesize(spec,dur,delay,itd,bc,rise,fall,ldb,rdb,side)
% USAGE: [DATA,ATT]=SYNTHESIZE(SPEC,DUR,DELAY,ITD,BC,RISE,FALL,LDB,RDB,SIDE);
%     
%        Synthesize a new waveform using xdphys synth routines.  If calib 
%        data has been loaded via the SET_CALIB function, ATT will hold PA4
%        attenuator settings necessary to achieve LDB and RDB with respect
%        to that calibration.  If calibration data has not been loaded, 
%        the attenuator settings will be calibrated with respect to a flat
%        70 dBspl calibration.
%
%   Outputs:
%
%        DATA   is a Nx2 array of waveform samples. DATA(:,1) is the 
%               left channel, and DATA(:,2) is the right.  
%               N=(((syn_info.epoch)/1000)*syn_info.daFc).
%        ATT    is a 1x2 array of attenuator settings.  Use
%
%                   set_att(ATT);
%
%               after calling synth to set the attenuators to the correct
%               level for the desired playback intensity.
%
%   Inputs:
%
%        DUR    is the duration of the waveform in ms
%        DELAY  is the delay in ms of the waveform from start of playback
%
%				DUR+DELAY must be < syn_info.epoch
%
%        ITD    is the itd between left and right sides, in microseconds
%        BC     is the binaural correlation between left and right sides,
%                     in percentage (-100 to 100)
%        RISE and FALL are rise and fall times of the sound envelope, in ms
%        LDB    is the playback intensity of left channel in dBspl
%        RDB    is the playback intensity of right channel in dBspl
%        SIDE   is 'left','right', or 'both'
%
%        SPEC is an xdphys stimspec, which is constructed as follows:
%
%              bb................. Broadband Noise
%              hp................. high pass noise (4-13k)
%              tone=NNN .......... pure tone of NNN hz
%              bp=lo-hi .......... band pass from f1-f2
%              CF=<cf>,BW=<w> .... bandpass from cf-(bw/2) to cf+(bw/2)
%              stack=<range>...... pure tone list (tone stack)
%                   where <range> can be any of (freqs in Hz):
%                      <from>:<to>:<stepsize>  (stepsize in Hz)
%                          divide range <from>-<to> into steps of
%                          size <stepsize>
%                      <from>:<to>:/<nsteps>
%                          divide range <from>-<to> into <nsteps>
%                          equally spaced steps
%                      <from>:<to>:@<nsteps>
%                          divide range <from>-<to> into <nsteps>
%                          exponentially spaced steps
%                      <f1>(<dB1>),<f2>(<dB2>),...,<fN>(<dbN>)
%                          stack of tones, freqs (f1 - fN). Intensity
%                          of tone one is <dB1>, of
%                          of tone two is <dB2>, etc. 
%              fmsweep=from-to:n 
%                          FM Sweep (n == 1, if not specified..)
%
%        STIMSPEC EXAMPLES:
%
%           Broadband noise:       
%
%                      STIMSPEC='bb'
%
%           8kHz tone:
%
%                      STIMSPEC='tone=8000'
%
%           Stack with tones of 1kHz, 2kHz, 3kHz, all tones at 50dB:
%
%                      STIMSPEC='stack=1000,2000,3000'  with LDB=50, RDB=50 
%                                or
%                      STIMSPEC='stack=1000:3000:1000' with LDB=50, RDB=50 
%                                or
%                      STIMSPEC='stack=1000:3000:/2' with LDB=50, RDB=50 
%                                or
%                      STIMSPEC='stack=1000(50),2000(50),3000(50)'  
%
% SEE ALSO: SYN_INFO, SET_CALIB, GET_CALIB, TWOSOUND

[data,att]=synth('synthesize',spec,dur,delay,itd,bc,rise,fall,ldb,rdb,side);
