%define Version 1.0.18
%define Release 5

Summary		: The synth package provides stimulus synthesis routines 
Name		: synth
Version		: %{Version}
Release		: %{Release}
Group		: Applications/Scientific

Copyright	: GPL
Packager	: cmalek@etho.caltech.edu (Chris Malek)

BuildRoot	: /tmp/synth-%{Version}

Source		: ftp.etho.caltech.edu:/pub/xdphys/SOURCES/synth-%{Version}.tar.gz

%description
The synth package provides sound synthesis routines to produce 
intensity calibrated auditory stimuli.  A C library for linking 
with C programs and a MEX file for use with MATLAB are both provided.
Both the C library and MEX file control tdtproc, a process
which interacts with the DAQ equipment.

%prep
%setup -n synth

%build
make 
(cd matlab; make)

%install
DESTDIR=$RPM_BUILD_ROOT; export DESTDIR
[ -n "`echo $DESTDIR | sed -n 's:^/tmp/[^.].*$:OK:p'`" ] && rm -rf $DESTDIR ||
(echo "Invalid BuildRoot: '$DESTDIR'! Check this .spec ..."; exit 1) || exit 1

for dir in usr/local/lib usr/local/include usr/local/local-matlab; do
	install -m 755 -d $DESTDIR/$dir
done

INSTALL_ROOT=$DESTDIR/usr/local; export INSTALL_ROOT
make -e install
(cd matlab; make -e install)

%post
/sbin/ldconfig /usr/local/lib

%files
%defattr(-,root,root)
/usr/local/lib/libsynth.a
/usr/local/lib/libsynth.so.1.0.0
/usr/local/include/synth/synth.h
/usr/local/include/synth/calib.h
/usr/local/include/synth/cache.h
/usr/local/include/synth/stimarray.h
/usr/local/include/synth/misc.h
/usr/local/local-matlab/synth.mexglx
/usr/local/local-matlab/synthesize.m
/usr/local/local-matlab/get_calib.m
/usr/local/local-matlab/set_calib.m
/usr/local/local-matlab/syn_info.m
/usr/local/local-matlab/syn_init.m
/usr/local/local-matlab/twosound.m
/usr/local/local-matlab/click.m
