/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: misc.c,v 1.2 1999/01/13 19:30:45 bjarthur Exp $
** Program: xdphys
**    File: synthlib.c
**  Module: synth
**  Author: mazer, bjarthur
** Descrip: extra routines for compiling the libsynth.a, standalone
**          synth lib
**
** 98.12 bjarthur
**  made into independent library
**  changed name to misc.c
**
*******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

static void alert(char*,...);
static void notify(char*,...);

void (*syn_alert)(char*,...) = alert;
void (*syn_notify)(char*,...) = notify;


/* ------------------------------------------------------------------------
   alert: this replaces the alert() in pop.c
   ------------------------------------------------------------------------ */
static void alert(char *fmt, ...)
{
	va_list ap;
	char *p,*sval;
	int	ival;
	double	fval;

	va_start(ap, fmt);
	fprintf(stderr,"alert: ");
	for (p = fmt; *p; p++) {
		if (*p != '%') {
			fputc(*p, stderr);
			continue;
		}
		switch (*++p) {
			case 'd':
				ival = va_arg(ap, int);
				fprintf(stderr, "%d", ival);
				break;
			case 'f':
				fval = va_arg(ap, double);
				fprintf(stderr, "%f", fval);
				break;
			case 's':
				for (sval = va_arg(ap, char *); *sval; sval++)
					fputc(*sval, stderr);
				break;
			default:
				fputc(*p, stderr);
		}
	}
	fprintf(stderr,"\n");
	fflush(stderr);
	va_end(ap);
}

/* ------------------------------------------------------------------------
   notify: this replaces the notify() in pop.c
   ------------------------------------------------------------------------ */
static void notify(char *fmt, ...)
{
	va_list ap;
	char *p,*sval;
	int	ival;
	double	fval;

	va_start(ap, fmt);
	fprintf(stderr,"notify: ");
	for (p = fmt; *p; p++) {
		if (*p != '%') {
			fputc(*p, stderr);
			continue;
		}
		switch (*++p) {
			case 'd':
				ival = va_arg(ap, int);
				fprintf(stderr, "%d", ival);
				break;
			case 'f':
				fval = va_arg(ap, double);
				fprintf(stderr, "%f", fval);
				break;
			case 's':
				for (sval = va_arg(ap, char *); *sval; sval++)
					fputc(*sval, stderr);
				break;
			default:
				fputc(*p, stderr);
		}
	}
	fprintf(stderr,"\n");
	fflush(stderr);
	va_end(ap);
}
