function syn_info();
%  syn_info is a global struct used by the SYN_INIT, SYNTHESIZE, 
%     TWOSOUND, GET_CALIB and SET_CALIB functions.
%
%  syn_info is made visible to the global context by running any of the
%  synth related commands: SYN_INIT, GET_CALIB, SET_CALIB, SYNTHESIZE, or
%  TWOSOUND.  If you only want to see and set fields in syn_info, without
%  doing anything else, use SYN_INIT.
%  
%  To be able to see syn_info (after doing a SYN_INIT), you must make it 
%  visible to your local context by typing: 
%  
%       global syn_info;
%
%  The syn_info struct has the following changable fields:
%
%       debug:        set to 1 to see synth lib debugging messages
%       bb_low:       low freq for broadband noise, in Hz
%       bb_high:      high freq for broadband noise, in Hz
%       daFc:         sampling frequency, in Hz
%       epoch:        synthesize buffer length, in ms
%       attMaxAtten:  maximum achievable attenuation for the programmable 
%                        attenuators
%       stack_rms:    if set to 1, when synthesizing a stack, dB 
%                        parameters refer to RMS of stack
%                     if set to 0, when synthesizing a stack, dB 
%                        parameters refer to absolute intensity of stack
%       twosound_rms: if set to 1, when doing twosound synthesis, 
%                        dB parameters refer to RMS of resulting waveform
%                     if set to 0, when doing twosound synthesis, 
%                        dB parameters refer to absolute intensity of 
%                        resulting waveform
%       use_cache:    if set to 1, extract noise waveforms from a cached
%                        copy when noise is needed
%                     if set to 0, synthesize new noise waveforms each 
%                        time noise is needed
%       rad_vary:     not really much use right now
%
%
%  The syn_info struct has the following unchangable field:
%
%       cal_loaded:   if set to 1, calibration vectors have been given to
%                        the synthesis routines via SET_CALIB.
%                     if set to 0, a flat 70dB calibration is being used
%
%
% SEE ALSO: SYN_INIT, GET_CALIB, SET_CALIB, SYNTHESIZE, TWOSOUND

