function set_calib(freq, mag, phase)
% USAGE: SET_CALIB(FREQ,MAG,PHASE);
%     
%        set_calib() tells the xdphys synth routines (SYNTHESIZE and
%        TWOSOUND) to use the calibration data contained in FREQ,
%        MAG and PHASE to produce intesity and phase calibrated waveforms.
%
%          FREQ    is an Mx2 array of frequencies in Hz
%          MAG     is an 2xM array of maximum achieveable intensities in dBspl
%                  for the frequencies in FREQ
%          PHASE   is an 2xM array of phase compesations, in radians,
%                  for the frequencies in FREQ
%
%        FREQ, MAG, and PHASE are precisely the three arrays returned by
%        xdview_getcal().
%
% SEE ALSO:  GET_CALIB, XDVIEW_GETCAL, SYNTHESIZE, TWOSOUND

synth('set_calib',freq,mag,phase)

