function [freq,mag,phase]=get_calib;
% USAGE: [FREQ,MAG,PHASE]=GET_CALIB;
%     
%        get_calib() returns the calibration data currently being used by 
%        the synth package to calibrate stimuli.
%
%          FREQ    is an Mx2 array of frequencies in Hz
%          MAG     is an 2xM array of maximum achieveable intensities in dBspl
%                  for the frequencies in FREQ
%          PHASE   is an 2xM array of phase compesations, in radians,
%                  for the frequencies in FREQ
%
%        FREQ, MAG, and PHASE are precisely the three arrays returned by
%        xdview_getcal().
%
% SEE ALSO:  SET_CALIB, XDVIEW_GETCAL, SYNTHESIZE, TWOSOUND

[freq,mag,phase]=synth('get_calib');

