function [data]=click(spec,delay,itd,side)
% USAGE: [DATA]=CLICK(SPEC,DELAY,ITD,SIDE);
%     
%        Synthesize a "click:" a square wave pulse of various lengths.
%        
%        The output is a rectangular pulse which has maximum voltage for n 
%        sampling points  (n = 1,2,..10,100).
% 
%        Will do both rarefaction (negative voltage) and condensation (positive
%        voltage) depending on value of the type field: 0=rarefaction, 
%        1=condensation.
%  
%        Note that no attenuator settings are returned: This is UNCALIBRATED.  
% 
%        Note: Can only shift ITD in integral multiples of sampling period.
% 
%   Outputs:
%
%        DATA   is a Nx2 array of waveform samples. DATA(:,1) is the 
%               left channel, and DATA(:,2) is the right.  
%               N=(((syn_info.epoch)/1000)*syn_info.daFc).
%
%   Inputs:
%
%        DELAY  is the delay in ms of the waveform from start of playback
%
%				DUR+DELAY must be < syn_info.epoch
%
%        ITD    is the itd between left and right sides, in microseconds
%        SIDE   is 'left','right', or 'both'
%
%        SPEC is one of two things:
%
%              rare_click=<n>............. rarefaction click (voltage < 0)
%                                          length is <n> samples
%              cond_click=<n>............. condensation click (voltage > 0)
%                                          length is <n> samples
%
% SEE ALSO: SYN_INFO, SYN_INIT

[data]=synth('click',spec,delay,itd,side);
