/*
 * ** This file is part of XDowl
 * ** Copyright (c) 1994 Jamie Mazer
 * ** California Institute of Technology
 * ** <mazer@asterix.cns.caltech.edu>
 */

/******************************************************************
**  RCSID: $Id: calib.h,v 1.2 1999/01/13 19:30:45 bjarthur Exp $
** Program: xdphys
**  Module: earcal.h
**  Author: mazer
** Descrip: header file for earcal.c
**
** Revision History (most recent last)
**
*******************************************************************/

#ifndef _cal_H_
#define _cal_H_

#include "synth.h"

extern float cal_max_atten;

#define CAL_MAX_CAL_PTS 500

#define CAL_RELOAD_YES 1
#define CAL_RELOAD_ASK 2
#define CAL_RELOAD_NO  3

#define CAL_LEFT_TOO_LOUD  (1 << 0)
#define CAL_LEFT_TOO_SOFT  (1 << 1)
#define CAL_RIGHT_TOO_LOUD (1 << 2)
#define CAL_RIGHT_TOO_SOFT (1 << 3)
#define CAL_ERROR          (1 << 4)

extern int cal_GetTime(void);
extern float cal_GetOverallMinDBSPL(int);

extern int cal_SetData(int, float*,float*,float*,float*,float*,int);
extern int cal_FakeFlatCal(char**);

extern int cal_FigureAtten(syn_spec *, float, float, float *, float *);
extern int cal_SafeFigureAtten(syn_spec *, float, float, float *, float *);

extern int cal_FigureSPL(syn_spec *, float, float, float *, float *);
extern int cal_SafeFigureSPL(syn_spec *, float, float, float *, float *);

extern void cal_PlotData(void);

extern int cal_FigureCal(float, float *, float *, float *, float *);

extern void unwrap(float *, int, float);

extern int cal_get_nfreqs(void);
extern float *cal_get_ref_freqs(void);
extern float *cal_get_rdbspl(void);
extern float *cal_get_ldbspl(void);
extern float *cal_get_rusphi(void);
extern float *cal_get_lusphi(void);
extern int cal_get_time(void);

#endif /* _cal_H_ */
