/*
**	This file is part of XDowl
**	Copyright (c) 1994 Jamie Mazer
**	California Institute of Technology
**	<mazer@asterix.cns.caltech.edu>
*/

/******************************************************************
**  RCSID: $Id: cache.h,v 1.5 2000/03/23 00:46:33 bjarthur Exp $
** Program: xdphys
**  Module: cache.h
**  Author: mazer
** Descrip: header file for cache.c
**
** Revision History (most recent last)
**
** Wed Feb  9 11:09:20 1994 mazer
**  creation date
**
*******************************************************************/

#ifndef _CACHE_H_
#define _CACHE_H_

typedef struct cnode *CachePtr;
typedef struct cnode {
  syn_spec ss;      /* stimuli description */
  int itd;
  int bc;
  int nsamps;     /* number of samples */
  int nchans;     /* number of channels */
  /* int rise, fall;   envelope parms */
  int lr;     /* monoaural, or binaural */
  int fc;     /* sampling freq in Hz */
  int cal_time;     /* calibration time */
  float *signal;    /* waveform */
  CachePtr nextsrc; /* private.. */
} CacheItem;

extern CachePtr cache_new(syn_spec*, int,int,int,int,int,int /*,int,int*/);
extern CachePtr cache_get(syn_spec*, int,int,int,int,int,int,int /*,int,int*/);
extern int 			cache_delete(CachePtr);
extern void     cache_delete_all(void);
extern int 	  	cache(syn_spec*, float*, int,int,int,int,int /*,int,int*/);

#endif /* _CACHE_H_ */
