#ifndef _SRL_H_
#define _SRL_H_

typedef struct {
  float *tm;		/* spike times in msecs */
  int nspikes;		/* number of spikes */
  float dur;		/* duration of collection in msecs */
} SA_SpikeRaster;

typedef struct {
  SA_SpikeRaster **sr;	/* an array of spike rasters */
  int nrasters;		/* the number of rasters */
} SA_SpikeRasterList;

void SA_InitSpikeRaster(SA_SpikeRaster**, int, float, float*);
void SA_SetSpikeRaster(SA_SpikeRaster*, float, float*,int);
void SA_FreeSpikeRaster(SA_SpikeRaster*);
void SA_InitSpikeRasterList(SA_SpikeRasterList**, int, float);
void SA_SetSpikeRasterListElt(SA_SpikeRasterList*, int, float, float*, int);
void SA_FreeSpikeRasterList(SA_SpikeRasterList*);
int SA_TotalSpikesInSRL(SA_SpikeRasterList*);

#endif /* _SRL_H_ */
