#ifdef MNEMOSYNE
#include "mnemosyne.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include "srl.h"

void SA_InitSpikeRaster(
     SA_SpikeRaster **srp,
     int nspikes,
     float dur,
     float *opt_spike_times)		/* Must be NULL if not used */
{
  int i;

  *srp = (SA_SpikeRaster *)calloc(1,sizeof(SA_SpikeRaster));
  if (nspikes > 0) {
    (*srp)->tm = (float *)calloc(nspikes,sizeof(float));
  } else {
    (*srp)->tm = NULL;
  }

  if (opt_spike_times) {
    for (i=0; i<nspikes; i++)
      (*srp)->tm[i] = opt_spike_times[i];
    (*srp)->nspikes=nspikes;
  } else {
    (*srp)->nspikes=0;
  }
  (*srp)->dur = dur;
}

void SA_SetSpikeRaster(
     SA_SpikeRaster *sr,
     float dur,
     float *spike_times,
     int nspikes)
{
  int i;

  if (sr == NULL) return;

  if (sr->tm)
    free((char *)sr->tm);
  sr->tm = (float *)calloc(nspikes,sizeof(float));
  sr->dur = dur;
  sr->nspikes=nspikes;

  if (spike_times) {
    for (i=0; i<nspikes; i++)
      sr->tm[i] = spike_times[i];
  }
}

void SA_FreeSpikeRaster(
     SA_SpikeRaster *sr)
{
  if (sr != NULL) {
	if (sr->tm != NULL)
		free((char *)sr->tm);
    free((char *)sr);
  }
}

void SA_InitSpikeRasterList(
     SA_SpikeRasterList **srlp,
     int nrasters,
     float dur)
{
  int i;

  *srlp = (SA_SpikeRasterList *)calloc(1,sizeof(SA_SpikeRasterList));
  (*srlp)->sr = (SA_SpikeRaster **)calloc(nrasters,sizeof(SA_SpikeRaster *));
  (*srlp)->nrasters = nrasters;

  for (i=0; i<nrasters; i++)
    SA_InitSpikeRaster(&((*srlp)->sr[i]),0,dur,NULL);
}

void SA_SetSpikeRasterListElt(
     SA_SpikeRasterList *srl,
     int i,
     float dur,			/* duration of collection (msecs) */
     float *spike_times,	/* list of spike times (msecs) */
     int nspikes)
{
  if (srl == NULL) return;
  if (i<0 || i>=srl->nrasters) return;

  SA_SetSpikeRaster(srl->sr[i],dur,spike_times,nspikes);
}

void SA_FreeSpikeRasterList(
     SA_SpikeRasterList *srl)
{
  int i;

  if (srl) {
    for (i=0; i<srl->nrasters; i++)
      SA_FreeSpikeRaster(srl->sr[i]);
    free((char *)srl->sr);
    free((char *)srl);
  }
}

int SA_TotalSpikesInSRL(
     SA_SpikeRasterList *srl)
{
  int i,N;
  if (srl == NULL) return 0;

  N=0;
  for (i=0; i<srl->nrasters; i++)
    N += srl->sr[i]->nspikes;
  return N;
}
