/* Functions to calculate the pst histograms */

#ifdef MNEMOSYNE
#include "mnemosyne.h"
#endif

#include <stdio.h>
#include <math.h>

#include "sahist.h"
#include "srl.h"
#include "psth.h"

/*****************************************************
** 97.7 bjarthur
**  added triangle_flag.  if 1, convolves with a triangle
**    filter, instead of a boxcar.  reduces aliasing.
**    see Paulin, M. G.  (1992).
*****************************************************/

SA_Histogram *SA_Psth(
		SA_SpikeRasterList *srl,
		float tmin, float tmax,	/* window time in ms */
		int nbins,              /* number of bins */
		int triangle_flag)			
{
	float binwidth;
	float *r, t;
	int i, j, n, bnum;
	SA_Histogram *h;

	binwidth = (tmax - tmin) / (float) nbins;
	h = SA_NewSA_Histogram(nbins);

	for (i = 0; i < nbins; i++) {
		(h->x)[i] = tmin + (i * binwidth);
		(h->y)[i] = 0.0;
	}

	for (i = 0; i < srl->nrasters; i++) {
		r = srl->sr[i]->tm;
		n = srl->sr[i]->nspikes;
		for (j = 0; j < n; j++) {
			t = (r[j] - tmin) / binwidth;
			if (t >= 0.0)
				bnum = (int) (t + 0.5);
			else
				bnum = (int) (t - 0.5);
			if (triangle_flag) {
				if ((bnum < nbins) && (bnum >= 0))
					(h->y)[bnum] += 0.75;
				if ((bnum < (nbins - 1)) && (bnum >= 0))
					(h->y)[bnum + 1] += 0.125;
				if ((bnum < nbins) && (bnum >= 1))
					(h->y)[bnum - 1] += 0.125;
			} else if ((bnum < nbins) && (bnum >= 0))
				(h->y)[bnum] += 1.0;
		}
	}
	return (h);
}
