/* Functions to calculate the isi histograms */

#ifdef MNEMOSYNE
#include "mnemosyne.h"
#endif

#include <stdio.h>
#include <math.h>

#include "sahist.h"
#include "srl.h"
#include "isih.h"

SA_Histogram *SA_Isih(
     SA_SpikeRasterList *srl,
     float tmin, float tmax,	/* window time in ms */
     int nbins)			/* number of bins */
{
  float binwidth;
  float *r, dt;
  int i, j, n, bnum;
  SA_Histogram *h;

  binwidth = (tmax - tmin) / (float)nbins;
  h = SA_NewSA_Histogram(nbins);

  for (i = 0; i < nbins; i++) {
    (h->x)[i] = tmin + (i * binwidth);
    (h->y)[i] = 0.0;
  }

  for (i = 0; i < srl->nrasters; i++) {
    r = srl->sr[i]->tm;
    n = srl->sr[i]->nspikes;
    for (j = 1; j < n; j++) {
      dt = ((r[j] - r[j - 1]) - tmin) / binwidth;
      bnum = (int)floor((double)dt);
      if (bnum < nbins && bnum >= 0)
        (h->y)[bnum] += 1.0; } }

  return(h);
}
