typedef struct {
  float *m;	/* The spike density at 1-ms resolution */
  int dur;	/* The duration (length) of the spike density function */

  float *gu;	/* the means of the gaussian kernals (one per spike) */
  float *gs;	/* the standard deviations */
  int ng;	/* the number of kernals (= #spikes) */
} SA_SpikeDensity;

typedef struct {
  SA_SpikeDensity **sd;	/* An array of spike densities */
  int ndensities;	/* number of spike densities */
  float *mean;		/* mean of the spike densities */
  float *sig;		/* std dev of spike densities (1ms resolution) */
  float *sem;		/* std err of spike densities (1ms resolution) */
  int dur;		/* duration (length) of spike densities */
} SA_SpikeDensityList;

void SA_InitSpikeDensity(SA_SpikeDensity**, float, int);
void SA_FreeSpikeDensity(SA_SpikeDensity*);
void SA_InitSpikeDensityList(SA_SpikeDensityList**, int, int);
void SA_FreeSpikeDensityList(SA_SpikeDensityList*);
void SA_CalcSpikeDensity(SA_SpikeRaster*,SA_SpikeDensity**,float,int);
void SA_CalcSpikeDensityList(SA_SpikeRasterList*, SA_SpikeDensityList**,
                 float,int);
